﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Box2DX.Common;
using DxLibDLL;
using Nlgp1.B2DX;
using Nlgp1.Utilities;

namespace Nlgp1.Drawers {

	public sealed class ChipImage {

		public void Draw( Vec2 target ) {
			DX.DrawRectGraph( ( int )( MathF.Round( target.X ) ) , ( int )( MathF.Round( target.Y ) ), this.source.x , this.source.y , ChipImage.SizeSide , ChipImage.SizeSide , this.graph , false , false );
		}

		public ChipImage( DX.Graph graph , DX.POINT source ) {
			this.graph = graph;
			this.source = source;
		}

		private DX.Graph graph;
		private DX.POINT source;

		/// <summary>
		/// チップのサイズ
		/// </summary>
		public const int SizeSide = 32;
		/// <summary>
		/// デフォルトのマップチップサイズ
		/// </summary>
		public static readonly DX.SIZE Size = new DX.SIZE( ChipImage.SizeSide , ChipImage.SizeSide );
	}
}
