﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using Nlgp1.StageEditor.Instances;
using Nlgp1.StageEditor.Controls.Events;

namespace Nlgp1.StageEditor {
	internal class Program : ApplicationContext {
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		private static void Main() {
			DefaultTraceListener dtl = (DefaultTraceListener)Debug.Listeners["Default"];
			dtl.LogFileName = @".\debug.log";

			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault( false );
			Application.Run( new Program() );

			//try
			//{
			//    Application.Run(new StageEditorApplicationContext());
			//}
			//catch (Exception e)
			//{
			//    Debug.Write(e.StackTrace);
			//    MessageBox.Show(e.Message, "例外発生！！");
			//    throw;
			//}
		}

		private Program() {
			var stageEditor = new StageEditorForm();
			var stage = new StageNotify();
			var editor = new EditorNotify();

			StageInstance.Initialize( stageEditor , editor , stage );
			LayerSettingInstance.Initialize( stageEditor , editor , stage );
			ChipsetInstance.Initialize( stageEditor , editor , stage );
			LayerInstance.Initialize( stageEditor , editor , stage );

			StageEditorFormEvent.Initialize( stageEditor , editor , stage );
			MapControlEvent.Initialize( stageEditor.MapControl , editor , stage );
			LayerChipControlEvent.Initialize( stageEditor.LayerChipControl , editor , stage );
			LayerChipsetControlEvent.Initialize( stageEditor.LayerChipsetControl , editor , stage );
			LayersetControlEvent.Initialize( stageEditor.LayersetControl , editor , stage );

			stageEditor.Show();
		}
	}
}