﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.IO;
using System.Drawing;
using Nlgp1.Common;

namespace Nlgp1.StageEditor.Notifies {
	public class StageNotify : INotifyPropertyChanged {

		public string Path {
			get;
			set;
		}
		public int ChipSize {
			get;
			set;
		}
		public int RowNum {
			get;
			set;
		}
		public int ColumnNum {
			get;
			set;
		}
		public int Width {
			get {
				return ColumnNum * ChipSize;
			}
		}
		public int Height {
			get {
				return RowNum * ChipSize;
			}
		}
		public List<LayerNotify> LayerList {
			get;
			set;
		}
        public string BgmPath {
            get;
            set;
        }
		public void Create( string path , int chipSize , int row , int column ) {
			SetPath( path );
			this.ChipSize = chipSize;
			this.RowNum = row;
			this.ColumnNum = column;

			ChipsetImage.ChipSize = chipSize;
			this.LayerList = new List<LayerNotify>();

			OnPropertyChanged( "Create" );
		}

		public void SetPath( string path ) {
			this.Path = path;
			OnPropertyChanged( "SetPath" );
		}

		#region レイヤー操作

		public LayerNotify CreateLayer( string name ) {
			var layer = new LayerNotify( RowNum , ColumnNum );
			layer.SetProperty( name );
			layer.ChipsetPath = name + ".csv";
			return layer;
		}

		public void AddLayer( LayerNotify layer ) {
			this.LayerList.Add( layer );
			OnPropertyChanged( "AddLayer" );
		}

		public void RemoveLayer( int index ) {
			var layer = LayerList[index];
			RemoveLayer( layer );
		}

		public void RemoveLayer( LayerNotify layer ) {
			this.LayerList.Remove( layer );
			OnPropertyChanged( "RemoveLayer" );
		}

		public LayerNotify GetPreviousLayer( LayerNotify layer ) {
			var index = LayerList.IndexOf( layer ) - 1;
			if( index < 0 )
				return LayerNotify.None;
			else
				return LayerList[index];
		}

		public LayerNotify GetNextLayer( LayerNotify layer ) {
			var index = LayerList.IndexOf( layer ) + 1;
			if( index >= LayerList.Count )
				return LayerNotify.None;
			else
				return LayerList[index];
		}

		public void MoveUpLayer( int index ) {
			if( index >= LayerList.Count - 1 )
				return;

			var layer = LayerList[index];
			this.LayerList.Remove( layer );
			this.LayerList.Insert( index + 1 , layer );
			OnPropertyChanged( "MoveUpLayer" );
		}

		public void MoveUpLayer( LayerNotify layer ) {
			var index = LayerList.IndexOf( layer );
			MoveUpLayer( index );
		}

		public void MoveDownLayer( int index ) {
			if( index == 0 )
				return;

			var layer = LayerList[index];
			this.LayerList.Remove( layer );
			this.LayerList.Insert( index - 1 , layer );
			OnPropertyChanged( "MoveDownLayer" );
		}

		public void MoveDownLayer( LayerNotify layer ) {
			var index = LayerList.IndexOf( layer );
			MoveDownLayer( index );
		}

		#endregion

		#region INotifyPropertyChanged メンバ

		public event PropertyChangedEventHandler PropertyChanged;
		public void OnPropertyChanged( string name ) {
			if( PropertyChanged == null )
				return;

			var e = new PropertyChangedEventArgs( name );
			PropertyChanged( this , e );
		}

		#endregion
	}
}