﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.ComponentModel;

namespace Nlgp1.StageEditor.Notifies
{
	public class LayerSettingNotify : INotifyPropertyChanged
	{
		public static readonly LayerSettingNotify None = new LayerSettingNotify();

		public bool Visible { get; private set; }
		public bool Foreground { get; private set; }
		public bool OtherHide { get; private set; }
		public Color FrameColor { get; private set; }

		public LayerSettingNotify()
		{
			Visible = true;
		}

		public void SetLayerSetting(LayerSettingNotify layerSetting)
		{
			this.SetLayerSetting(
				layerSetting.Visible,
				layerSetting.Foreground,
				layerSetting.OtherHide,
				layerSetting.FrameColor);
		}

		public void SetLayerSetting(bool visible, bool foreground, bool otherHide, Color frameColor)
		{
			this.Visible = visible;
			this.Foreground = foreground;
			this.OtherHide = otherHide;
			this.FrameColor = frameColor;
			OnPropertyChanged("SetLayerSetting");
		}

		#region INotifyPropertyChanged メンバ

		public event PropertyChangedEventHandler PropertyChanged;
		private void OnPropertyChanged(string name)
		{
			if (PropertyChanged == null) return;

			var e = new PropertyChangedEventArgs(name);
			PropertyChanged(this, e);
		}

		#endregion

	}
}
