﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing.Design;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms.Design;
using System.Windows.Forms;
using Nlgp1.StageEditor.Controls;
using Nlgp1.Common;

namespace Nlgp1.StageEditor.Notifies.LayerChipProperties
{
	class LayerChipTypeEditor : UITypeEditor
	{
		public LayerChipTypeControl Control { get; set; }

		public LayerChipTypeEditor()
		{
		}
		public override object EditValue(ITypeDescriptorContext context, IServiceProvider sp, object value) 
		{
			IWindowsFormsEditorService edSvc = (IWindowsFormsEditorService)sp.GetService(typeof(IWindowsFormsEditorService));

			if (edSvc == null) return value;

			if (Control == null) 
			{
				Control = new LayerChipTypeControl();
			}
			Control.Type = ( ( string )( value ) ).ToEnum< LayerChipType >();

			edSvc.DropDownControl(Control);

			return Control.Type.ToString();
		}

		public override System.Drawing.Design.UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context) 
		{
			return System.Drawing.Design.UITypeEditorEditStyle.Modal;
		}
	}
}