﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.ComponentModel;
using Nlgp1.Common;

namespace Nlgp1.StageEditor.Notifies
{
	public class EditorNotify : INotifyPropertyChanged
	{
		private LayerNotify currentLayer;
		private LayerChipNotify currentChip;

		private Dictionary<LayerNotify, LayerSettingNotify> layerSettingTable;

		public LayerNotify CurrentLayer
		{
			get{ return currentLayer; }
			set{
				if (currentLayer == value) return;
				currentLayer = value;
				OnPropertyChanged("CurrentLayer");
			}
		}
		public LayerChipNotify CurrentChip
		{
			get { return currentChip; }
			set {
				if (currentChip == value) return;
				currentChip = value;
				OnPropertyChanged("CurrentChip");
			}
		}
		public void SetCurrentChip(LayerNotify layer, LayerChipNotify chip)
		{
			this.currentChipTable[layer] = chip;
		}
		private Dictionary<LayerNotify, LayerChipNotify> currentChipTable;
		public LayerChipNotify GetCurrentChip(LayerNotify chipset)
		{
			return currentChipTable[chipset];
		}

		public bool VisibleGrid { get; private set; }
		public int GridSize { get; private set; }
		public Color GridColor { get; private set; }

		public float Scale { get; private set; }

		public void Create()
		{
			this.currentChipTable = new Dictionary<LayerNotify, LayerChipNotify>();
			this.currentChipTable[LayerNotify.None] = LayerChipNotify.None;

			this.CurrentLayer = LayerNotify.None;
			this.CurrentChip = LayerChipNotify.None;

			//SetGridProperty(true, MapBase.CellSize , Color.Black);
			SetGridProperty(true, LayerChipData.SizeSide, Color.Yellow);
			SetScale(1.0f);

			this.layerSettingTable = new Dictionary<LayerNotify, LayerSettingNotify>();
			this.layerSettingTable[LayerNotify.None] = LayerSettingNotify.None;

			OnPropertyChanged("Create");
		}

		public void SetGridProperty(bool visible, int size, Color color)
		{
			this.VisibleGrid = visible;
			this.GridSize = size;
			this.GridColor = color;
			OnPropertyChanged("SetGridProperty");
		}

		public void SetScale(float scale)
		{
			this.Scale = scale;
			OnPropertyChanged("SetScale");
		}

		public void AddLayer(LayerNotify layer, LayerSettingNotify layerSetting)
		{
			currentChipTable.Add(layer, LayerChipNotify.None);
			AddLayerSetting(layer, layerSetting);
		}

		public void RemoveLayer(LayerNotify layer)
		{
			currentChipTable.Remove(layer);
			RemoveLayerSetting(layer);
		}


		#region LayerSetting操作

		public LayerSettingNotify CreateLayerSetting()
		{
			var layerSetting = new LayerSettingNotify();
			return layerSetting;
		}

		private void AddLayerSetting(LayerNotify layer, LayerSettingNotify layerSetting)
		{
			this.layerSettingTable[layer] = layerSetting;
			OnPropertyChanged("AddLayerSetting");
		}

		private void RemoveLayerSetting(LayerNotify layer)
		{
			this.layerSettingTable.Remove(layer);
			OnPropertyChanged("RemoveLayerSetting");

		}

		public LayerSettingNotify GetCurrentLayerSetting()
		{
			return GetLayerSetting(CurrentLayer);
		}

		// TODO コレクションに変更する
		public LayerSettingNotify GetLayerSetting(LayerNotify layer)
		{
			var layerSetting = LayerSettingNotify.None;
			if (layerSettingTable.ContainsKey(layer))
			{
				layerSetting = layerSettingTable[layer];
			}
			return layerSetting;
		}

		#endregion

		public void UpdateChipImageSet(ChipsetImage imageSet)
		{
			// TODO TextureBrushのリストを作る
		}

		#region INotifyPropertyChanged メンバ

		public event PropertyChangedEventHandler PropertyChanged;
		public void OnPropertyChanged(string name)
		{
			if (PropertyChanged == null) return;
			var e = new PropertyChangedEventArgs(name);
			PropertyChanged(this, e);
		}

		#endregion
	}
}
