﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using Nlgp1.StageEditor.Notifies.LayerChipProperties;
using System.Drawing;
using Nlgp1.Common;

namespace Nlgp1.StageEditor.Instances {
	public static class StageInstance {
		private static StageEditorForm stageEditor;
		private static StageNotify stage;
		private static EditorNotify editor;

		public static void Initialize( StageEditorForm stageEditor , EditorNotify editor , StageNotify stage ) {
			StageInstance.stageEditor = stageEditor;
			StageInstance.stage = stage;
			StageInstance.editor = editor;
		}

		public static void Create( string path , int chipSize , int row , int column ) {
			editor.Create();
			stage.Create( path , chipSize , row , column );

			var layerNames = Enum.GetNames( typeof( LayerType ) );
			foreach( var layerName in layerNames ) {
				var layer = LayerInstance.Add( layerName );
				editor.SetCurrentChip( layer , LayerChipNotify.None );
			}
			LayerInstance.SetCurrentLayer( 0 );
			//
			LayerSettingInstance.SetGridProperty(true, LayerChipData.SizeSide, Color.Yellow);
		}

		public static void Load( string path ) {
			NotifyLoader.LoadStageFromFile( stage , editor , path );
		}

		public static void Save( string path , StageNotify stage ) {
			NotifySaver.SaveStageToFile( path , stage );

		}
		public static EditorNotify Editor {
			get {
				return editor;
			}
		}
		public static StageNotify Stage {
			get{
				return stage;
			}
		}
	}
}