﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Nlgp1.StageEditor.Notifies
{
	public partial class StageCreaterForm : Form
	{
		private event EventHandler CreateButtonClicked;
		private event EventHandler CancelButtonClicked;

		public string StageName {
			get { return NameTextBox.Text; }
			set { NameTextBox.Text = value; }
		}
		public int ChipSize {
			get { return (int)ChipSizeNumeric.Value; }
			set { ChipSizeNumeric.Value = value; }
		}
		public int RowNum {
			get { return (int)MapRowNumeric.Value; }
			set { MapRowNumeric.Value = value; }
		}
		public int ColumnNum {
			get { return (int)MapColumnNumeric.Value; }
			set { MapColumnNumeric.Value = value; }
		}

		public StageCreaterForm()
		{
			InitializeComponent();
		}

		private void MapRowNumeric_ValueChanged(object sender, EventArgs e)
		{
			MapHeightTextBox.Text = CalculateHeight();
		}

		private void MapColumnNumeric_ValueChanged(object sender, EventArgs e)
		{
			MapWidthTextBox.Text = CalculateWidth();
		}

		private void ChipSizeNumeric_ValueChanged(object sender, EventArgs e)
		{
			MapWidthTextBox.Text = CalculateWidth();
			MapHeightTextBox.Text = CalculateHeight();
		}

		private string CalculateWidth()
		{
			var chipSize = (int)ChipSizeNumeric.Value;
			var column = (int)MapColumnNumeric.Value;
			var width = chipSize * column;
			return width.ToString();
		}

		private string CalculateHeight()
		{
			var chipSize = (int)ChipSizeNumeric.Value;
			var row = (int)MapRowNumeric.Value;
			var height = chipSize * row;
			return height.ToString();
		}

		private void CreateButton_Click(object sender, EventArgs e)
		{
			if (CreateButtonClicked != null)
			{
				CreateButtonClicked(sender, e);
			}

			this.DialogResult = DialogResult.OK;
		}

		private void MyCancelButton_Click(object sender, EventArgs e)
		{
			if (CancelButtonClicked != null)
			{
				CancelButtonClicked(sender, e);
			}

			this.DialogResult = DialogResult.Cancel;
		}
	}
}
