﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Nlgp1.StageEditor.Notifies;

namespace Nlgp1.StageEditor.Controls
{
	public partial class LayersetControl : UserControl
	{
        public string soundfile = "";
        WMPLib.WindowsMediaPlayer player = new WMPLib.WindowsMediaPlayer();
        

		public int SelectedTabIndex {
			get { return TabControl.SelectedIndex; }
			set { TabControl.SelectedIndex = value; }
		}

		private Dictionary<LayerNotify, LayerTabPage> tabPageTable = new Dictionary<LayerNotify, LayerTabPage>();

		public LayersetControl()
		{
			InitializeComponent();
            this.player.EndOfStream += new WMPLib._WMPOCXEvents_EndOfStreamEventHandler(player_EndOfStream);
			this.tabPagesCount = this.TabControl.TabPages.Count;

			this.LayerAdderControl.Add += (sender, e) => OnLayerAdd(e.Name, e.DefaultChipID);
		}

        void player_EndOfStream(int Result) {
            PlayButton.Text = "play";
            throw new NotImplementedException();
        }

		public LayerTabPage CreateLayer(string name)
		{
			var page = new LayerTabPage(name);
			return page;
		}

		public void AddLayer(LayerTabPage tabPage)
		{
			var index = TabControl.TabPages.Count - this.tabPagesCount;
			TabControl.TabPages.Insert(index, tabPage);
		}

		public void RemoveLayer(LayerTabPage tabPage)
		{
			TabControl.TabPages.Remove(tabPage);
		}

		public void MoveDownLayer(LayerTabPage tabPage)
		{
			var index = TabControl.TabPages.IndexOf(tabPage) - 1;
			if (index >= 0) {
				TabControl.TabPages.Remove(tabPage);
				TabControl.TabPages.Insert(index, tabPage);
			}
		}

		public void MoveUpLayer(LayerTabPage tabPage)
		{
			var index = TabControl.TabPages.IndexOf(tabPage) + 1;
			var tail = TabControl.TabPages.Count - this.tabPagesCount;
			if (index < tail) {
				TabControl.TabPages.Remove(tabPage);
				TabControl.TabPages.Insert(index, tabPage);
			}
		}

		public void MapData_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			var stage = (StageNotify)sender;
			if (e.PropertyName == "Create") ClearLayerTab();

			this.LayerAdderControl.MapData_PropertyChanged(sender, e);
		}

		public void ChipGridData_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			var layer = (LayerNotify)sender;
		}

		public LayerControl CurrentLayerControl{
			get{
				 return ((LayerTabPage)TabControl.SelectedTab).LayerControl;
			}
		}

		private void ClearLayerTab()
		{
			while (this.TabControl.TabPages.Count > this.tabPagesCount) {
				this.TabControl.TabPages.RemoveAt(0);
			}
		}

		public event TabControlEventHandler LayerTabSelected;
		private void TabControl_Selected(object sender, TabControlEventArgs e)
		{
			if (LayerTabSelected == null) return;
			LayerTabSelected(this, e);
		}

		#region LayerAdd

		public delegate void LayerAddEventHandler(object sender, LayerAddEventArgs e);
		public event LayerAddEventHandler LayerAdd;

		public void OnLayerAdd(string name, int defaultChipID)
		{
			if (LayerAdd == null) return;

			var e = new LayerAddEventArgs(name, defaultChipID);
			LayerAdd(this, e);
		}

		public class LayerAddEventArgs : EventArgs
		{
			public string Name { get; private set; }
			public int DefaultChipID { get; private set; }
			public LayerAddEventArgs(string name, int defaultChipID)
			{
				this.Name = name;
				this.DefaultChipID = defaultChipID;
			}
		}
		#endregion

		private readonly int tabPagesCount;
        #region player部分
        private void PlayButton_Click(object sender, EventArgs e) {
            if (PlayButton.Text == "play") {
                PlayButton.Text = "stop";
                player.URL = soundfile;
                player.settings.volume = 100 - Volume.Value*10;
                player.controls.play();
            }
            else {
                PlayButton.Text = "play";
                player.controls.stop();
            }
        }

        private void Setting_Click(object sender, EventArgs e) {
            var result = openFileDialog1.ShowDialog();
            if (result != DialogResult.OK) return;
            soundfile = openFileDialog1.FileName;
            MusicPath.Text = soundfile;
        }

        private void Volume_Scroll(object sender, EventArgs e) {
            player.settings.volume = 100 - Volume.Value*10;
        }
        #endregion

        private void MusicPath_DragDrop(object sender, DragEventArgs e) {
            soundfile = e.Data.GetData(DataFormats.Text).ToString();
        }

        private void MusicPath_TextChanged(object sender, EventArgs e) {
            soundfile = MusicPath.Text;
        }

        public void ChangeMusicPath(string path) {
            MusicPath.Text = path;
        }

    }

	public class LayerTabPage : TabPage
	{
		public LayerControl LayerControl { get; private set; }
		public LayerTabPage(string name)
			: base(name)
		{
			LayerControl = new LayerControl(name);
			this.AutoScroll = true;
			this.Controls.Add(LayerControl);
		}

		public void ChipGridData_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			var layer = (LayerNotify)sender;
			if (e.PropertyName == "SetProperty") this.Text = layer.Name;

			this.LayerControl.ChipGridData_PropertyChanged(sender, e);
		}

		public void ViewSettingData_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			this.LayerControl.ViewSettingData_PropertyChanged(sender, e);
		}
	}
}
