﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Nlgp1.StageEditor.Notifies;

namespace Nlgp1.StageEditor.Controls
{
	public partial class LayerControl : UserControl
	{
		private static LayerSettingForm layerSettingForm;

		private Color prevColro;
		private Color frameColor;
		public Color FrameColor
		{
			get { return frameColor; }
			set { 
				frameColor = value;
				FrameColorBox.BackColor = frameColor;
				FrameColorBox.Refresh();

				if (value != Color.Empty)
				{
					prevColro = value;
				}
			}
		}

		private string layerName;

		static LayerControl()
		{
			LayerControl.layerSettingForm = new LayerSettingForm();
		}

		public LayerControl(string name)
		{
			InitializeComponent();
			this.prevColro = Color.Red;
			this.layerName = name;
		}

		public void ChipGridData_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			var layer = (LayerNotify)sender;
			if (e.PropertyName == "SetProperty") this.layerName = layer.Name;
		}

		public void ViewSettingData_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			var viewerSetting = (LayerSettingNotify)sender;
			this.VisibleCheckBox.Checked = viewerSetting.Visible;
			this.ForegroundCheckBox.Checked = viewerSetting.Foreground;
			this.OtherHideCheckBox.Checked = viewerSetting.OtherHide;
			this.FrameColor = viewerSetting.FrameColor;
		}

		#region 表示設定の変更
		private void VisibleCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			OnViewSettingChanged();
		}

		private void ForegroundCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			OnViewSettingChanged();
		}

		private void OtherHideCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			OnViewSettingChanged();
		}

		private void FrameColor_Click(object sender, EventArgs e)
		{
			if (FrameColor == Color.Empty)
			{
				ColorDialog.Color = prevColro;
				var result = ColorDialog.ShowDialog();
				if (result != DialogResult.OK) return;

				FrameColor = ColorDialog.Color;
			}
			else
			{
				FrameColor = Color.Empty;
			}

			OnViewSettingChanged();
		}
		#endregion

		#region 描画
		private void FrameColorBox_Paint(object sender, PaintEventArgs e)
		{
			if (frameColor != Color.Empty) return;
			var rect = e.ClipRectangle;
			e.Graphics.DrawLine(Pens.Black, rect.Left, rect.Top, rect.Right, rect.Bottom);
		}
		#endregion

		#region ボタンクリック
		private void LayerDownButton_Click(object sender, EventArgs e)
		{
			OnCommand("MoveDown");
		}

		private void LayerUpButton_Click(object sender, EventArgs e)
		{
			OnCommand("MoveUp");
		}

		private void LayerDeleteButton_Click(object sender, EventArgs e)
		{
			OnCommand("Delete");
		}

		private void Setting_Click(object sender, EventArgs e)
		{
			layerSettingForm.LayerName = layerName;
			var result = layerSettingForm.ShowDialog();
			if (result != DialogResult.OK) return;

			var name = layerSettingForm.LayerName;
			OnLayerPropertyChanged(name);
		}
		#endregion

		#region LayerProipertyChanged
		public delegate void LayerProipertyChangedEventHandler(object sender, LayerProipertyChangedEventArgs e);
		public event LayerProipertyChangedEventHandler LayerProipertyChanged;

		private void OnLayerPropertyChanged(string name)
		{
			if (ViewSettingChanged == null) return;

			var e = new LayerProipertyChangedEventArgs(name);
			LayerProipertyChanged(this, e);
		}

		public class LayerProipertyChangedEventArgs : EventArgs
		{
			public string Name { get; private set; }

			public LayerProipertyChangedEventArgs(string name)
			{
				this.Name = name;
			}
		}

		#endregion

		#region ViewSettingChanged
		public delegate void ViewSettingChangedHandler(object sender, ViewSettingChangedEventArgs e);
		public event ViewSettingChangedHandler ViewSettingChanged;

		private void OnViewSettingChanged()
		{
			if (ViewSettingChanged == null) return;

			var e = new ViewSettingChangedEventArgs(
				VisibleCheckBox.Checked,
				ForegroundCheckBox.Checked,
				OtherHideCheckBox.Checked,
				FrameColor);

			ViewSettingChanged(this, e);
		}

		public class ViewSettingChangedEventArgs : EventArgs
		{
			public LayerSettingNotify ViewSetting { get; private set; }

			public ViewSettingChangedEventArgs(bool visible, bool foreground, bool otherHide, Color frameColor)
			{
				this.ViewSetting = new LayerSettingNotify();
				this.ViewSetting.SetLayerSetting(
					visible, foreground, otherHide, frameColor);
			}
		}

		#endregion

		#region Command
		public delegate void CommandEventHandler(object sender, CommandEventArgs e);
		public event CommandEventHandler Command;

		public void OnCommand(string command)
		{
			if (Command == null) return;

			var e = new CommandEventArgs(command);
			Command(this, e);
		}

		public class CommandEventArgs : EventArgs
		{
			public string Command { get; set; }
			public CommandEventArgs(string command)
			{
				this.Command = command;
   		}
		}
		#endregion

		private void AllClear_Click( object sender , EventArgs e ) {
			OnCommand("Clear");
		}
	}
}
