﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Notifies.LayerChipProperties;

namespace Nlgp1.StageEditor.Controls {
	// TODO キャプションバーを付けたい
	public partial class LayerChipControl : UserControl {
		private LayerChipNotify currentChip = LayerChipNotify.None;
		private ChipsetImage chipImageSet = ChipsetImage.None;

		private LayerChipNotify CurrentChip {
			get {
				return currentChip;
			}
			set {
				if( currentChip == value )
					return;
				currentChip = value;
				UpdateViewer();
			}
		}
		private ChipsetImage ChipsetImage {
			get {
				return chipImageSet;
			}
			set {
				if( chipImageSet == value )
					return;
				chipImageSet = value;
				UpdateViewer();
			}
		}

		private LayerChipSelectorControl layerChipSelecterControl;

		public LayerChipControl() {
			InitializeComponent();

			this.ImageNumberButton.Visible = false;
			this.layerChipSelecterControl = new LayerChipSelectorControl();

			this.PropertyGrid.PropertyValueChanged +=
				( sender , e ) => OnChipPropertyChanged( (LayerChipProperty)PropertyGrid.SelectedObject );
		}

		#region PropertyChanged
		public void MapData_PropertyChanged( object sender , PropertyChangedEventArgs e ) {
			var stage = (StageNotify)sender;
			//if (e.PropertyName == "Create") ChipsetImage = commonMap.ChipsetImage;
			//if (e.PropertyName == "SetMapProperty") ChipsetImage = commonMap.ChipsetImage;
			//if (e.PropertyName == "LoadLayerImage") ChipsetImage = commonMap.ChipsetImage;
		}

		public void ChipData_PropertyChanged( object sender , PropertyChangedEventArgs e ) {
			if( e.PropertyName == "SetProperty" )
				UpdateViewer();
		}


		public void ChipGridData_PropertyChanged( object sender , PropertyChangedEventArgs e ) {
			if( e.PropertyName == "SetChipsetImagePath" )
				UpdateViewer();
		}

		public void EditorData_PropertyChanged( object sender , PropertyChangedEventArgs e ) {
			var editor = (EditorNotify)sender;
			if( e.PropertyName == "CurrentLayer" )
				ChipsetImage = editor.CurrentLayer.ChipsetImage;
			if( e.PropertyName == "CurrentChip" ) {
				CurrentChip = editor.CurrentChip;
				var isNull = ( CurrentChip == LayerChipNotify.None );
				this.ImageNumberButton.Enabled = !( isNull );
			}
		}
		#endregion

		private void UpdateViewer() {
			var imageNumber = CurrentChip.Index;
			this.ThumbImage.Image = chipImageSet[imageNumber];

			this.PropertyGrid.SelectedObject = CurrentChip.Property;
			Refresh();
		}

		private void ImageNumberButton_Click( object sender , EventArgs e ) {
			if( currentChip == LayerChipNotify.None )
				return;

			this.layerChipSelecterControl.LayerImage = chipImageSet;
			this.layerChipSelecterControl.SelectedNumber = currentChip.Index;

			var result = layerChipSelecterControl.ShowDialog();
			if( result != DialogResult.OK )
				return;

			var propertyData = (LayerChipProperty)PropertyGrid.SelectedObject;
			OnChipPropertyChanged( propertyData );
		}

		#region ChipPropertyChangedEvent
		public event ChipPropertyChangedEventHandler ChipPropertyChanged;
		private void OnChipPropertyChanged( LayerChipProperty chip ) {
			if( ChipPropertyChanged == null )
				return;

			var e = new ChipPropertyChangedEventArgs( chip );
			ChipPropertyChanged( this , e );
		}

		public delegate void ChipPropertyChangedEventHandler( object sender , ChipPropertyChangedEventArgs e );
		public class ChipPropertyChangedEventArgs : EventArgs {
			public LayerChipProperty ChipProperty {
				get;
				set;
			}
			public ChipPropertyChangedEventArgs( LayerChipProperty chipProperty ) {
				this.ChipProperty = chipProperty;
			}
		}
		#endregion
	}
}
