﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using System.Drawing;
using Nlgp1.Common;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Controls.Events {
	public static class StageEditorFormEvent {
		public static void Initialize( StageEditorForm stageEditor , EditorNotify editor , StageNotify stage ) {
			stageEditor.Load += ( sender , e ) => {
				StageInstance.Create( "" , LayerChipData.SizeSide , 128 , 128 );
			};

			stageEditor.CreateNewStage += ( sender , e ) => {
				StageInstance.Create( "" , e.ChipSize , e.RowNum , e.ColumnNum );
			};

			stageEditor.LoadStage += ( sender , e ) =>
				StageInstance.Load( e.Path );

			stageEditor.SaveStage += ( sender , e ) =>
				StageInstance.Save( e.Path, stage );

			stageEditor.GridPropertyChenged += ( sender , e ) =>
				LayerSettingInstance.SetGridProperty( e.Visible , e.Size , e.Color );

			stageEditor.ScaleChenged += ( sender , e ) =>
				LayerSettingInstance.SetScale( e.Scale );

			var shiftTable = new Dictionary<string , Action<LayerNotify>>();
			shiftTable["Left"] = LayerInstance.ShiftLeft;
			shiftTable["Right"] = LayerInstance.ShiftRight;
			shiftTable["Up"] = LayerInstance.ShiftUp;
			shiftTable["Down"] = LayerInstance.ShiftDown;

			stageEditor.LayerShift += ( sender , e ) =>
				shiftTable[e.Direction]( editor.CurrentLayer );

			stage.PropertyChanged += stageEditor.MapData_PropertyChanged;
			editor.PropertyChanged += stageEditor.EditorData_PropertyChanged;

		}
	}
}
