﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using System.Windows.Forms;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Controls.Events
{
	public static class MapControlEvent
	{

		public static void Initialize(MapControl mapControl, EditorNotify editor, StageNotify stage)
		{
			int[,] map = null;
			int diffRow=0, diffCol=0;


			mapControl.ClickGrid += (sender, e) =>
   			{


   				if (e.IsCopying == false)
   				{


   					LayerInstance.SetChip(
					editor.CurrentLayer,
					editor.CurrentChip,
					e.Row, e.Column);
   					//MessageBox.Show(LayerController.GetChipIndex(editor.CurrentLayer, e.Row, e.Column).ToString());
   				}
   				else if (e.IsCopying == true)
   				{
   					for (int i = e.Row; i < e.Row+diffRow; i++)
   					{
   						for (int j = e.Column; j < e.Column+diffCol; j++)
   						{
   							LayerInstance.SetChipIndex(
   								editor.CurrentLayer,
   								map[i-e.Row,j-e.Column],
   								i, j);
   						}
   					}

   				}
		};

			mapControl.DragGrid += (sender, e) =>
				{



					if (e.IsCopying == false)
					{
						for (int i = e.Row; i < e.RowNum; i++)
						{
							for (int j = e.Column; j < e.ColumnNum; j++)
							{
								LayerInstance.SetChip(
									editor.CurrentLayer,
									editor.CurrentChip,
									i, j);
							}
						}
					}
					else if (e.IsCopying == true)
					{
						diffRow = e.RowNum - e.Row;
						diffCol = e.ColumnNum - e.Column;
						map = new int [diffRow,diffCol];
						for (int i = e.Row; i < e.RowNum; i++)
						{
							for (int j = e.Column; j < e.ColumnNum; j++)
							{
								map[i-e.Row,j-e.Column] = LayerInstance.GetChipIndex(
									editor.CurrentLayer,
									i, j);
							}
						}
						/*MessageBox.Show(chipIndex[0,0].ToString());
						MessageBox.Show(chipIndex[0, 1].ToString());
						MessageBox.Show(chipIndex[1, 0].ToString());
						MessageBox.Show(chipIndex[1, 1].ToString());*/
					}
				};

			//とりあえずLayerController.GetChipIndex(editor.CurrentLayer,i,j);でマップのIDが得られるはず。
			stage.PropertyChanged += mapControl.MapData_PropertyChanged;
			editor.PropertyChanged += mapControl.EditorData_PropertyChanged;

		}
   }
}