﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using System.Windows.Forms;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Controls.Events
{
	public static class LayersetControlEvent
	{
		public static void Initialize(LayersetControl layersetControl, EditorNotify editor, StageNotify stage)
		{
			layersetControl.LayerAdd += (sender, e) =>
			{
				var layer = LayerInstance.Add(e.Name);
				//LayerController.Add(e.Name, e.DefaultChipID);
				ChipsetInstance.Add(layer, layer.CreateChip());
			};

			layersetControl.LayerTabSelected += (sender, e) =>
			{
				var layer = LayerNotify.None;
				if (e.TabPageIndex > -1 &&
					e.TabPageIndex < stage.LayerList.Count)
				{
					layer = stage.LayerList[e.TabPageIndex];
				}
				LayerInstance.SetCurrentLayer(layer);
			};
            layersetControl.ChangeMusicPath(stage.BgmPath);
			stage.PropertyChanged += layersetControl.MapData_PropertyChanged;
		}
   }
}