﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Controls;
using Nlgp1.StageEditor.Notifies;
using System.Windows.Forms;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Controls.Events
{
	public static class LayerTabPageEvent
	{
		public static void Initialize(LayerTabPage layerTabPage, LayerNotify layer, LayerSettingNotify viewerSetting)
		{
			var CommanTable = new Dictionary<string, Action>();
			CommanTable["MoveUp"] = () => LayerInstance.MoveUp(layer);
			CommanTable["MoveDown"] = () => LayerInstance.MoveDown(layer);
			CommanTable["Delete"] = () => 
			{
			   var result = ShowDeleteMessage(layer.Name);
				if (result != DialogResult.OK) return;

   			LayerInstance.Remove(layer);
			};
			CommanTable["Clear"] = () => {
				for( int i = 0 ; i < layer.Map.GetLength( 0 ) ; i++ ) {
					for( int j = 0 ; j < layer.Map.GetLength( 1 ) ; j++ ) {
						layer.Map[ i , j ] = layer.ChipTable[ 0 ];
					}
				}
				layer.OnPropertyChanged( "SetGridData" );
			};

			layerTabPage.LayerControl.Command += (sender, e) =>
				CommanTable[e.Command]();

			layerTabPage.LayerControl.LayerProipertyChanged += (sender, e) =>
				layer.SetProperty(e.Name);

			layerTabPage.LayerControl.ViewSettingChanged += (sender, e) =>
				viewerSetting.SetLayerSetting(e.ViewSetting);

			layer.PropertyChanged += layerTabPage.ChipGridData_PropertyChanged;
			viewerSetting.PropertyChanged += layerTabPage.ViewSettingData_PropertyChanged;
		}

		private static DialogResult ShowDeleteMessage(string name)
		{
			var message = string.Format("{0}レイヤーを削除します", name);
			var result = MessageBox.Show(message, name,
				MessageBoxButtons.OKCancel, MessageBoxIcon.None,
				MessageBoxDefaultButton.Button2);

			return result;
		}
	}
}