﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using System.Windows.Forms;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Controls.Events
{
	public static class LayerChipsetControlEvent
	{
		public static void Initialize(LayerChipsetControl chipsetControl, EditorNotify editor, StageNotify stage)
		{
			var commandTable = new Dictionary<string, Action>();
			commandTable["Add"] = () => ChipsetInstance.Add(editor.CurrentLayer, editor.CurrentLayer.CreateChip());
			commandTable["Delete"] = () =>
			{
				var response = MessageBox.Show("本当に削除しますか？ステージは保存されてないかもしれませんよ？", "確認", MessageBoxButtons.YesNoCancel);

				if (response == DialogResult.Cancel)
				{
					return;
				}
				else if (response == DialogResult.Yes)
				{
					ChipsetInstance.Remove(editor.CurrentLayer, editor.CurrentChip);
				}

			};

			chipsetControl.ChipCommand += (sender, e) =>
				commandTable[e.Commnad]();

			chipsetControl.ImageLoad += (sender, e) =>
				LayerInstance.LoadImage(editor.CurrentLayer, e.Path);

			chipsetControl.ChipClicked += (sender, e) => 
				ChipsetInstance.SetCurrentChip(e.ChipData);

			stage.PropertyChanged += chipsetControl.MapData_PropertyChanged;
			editor.PropertyChanged += chipsetControl.EditorData_PropertyChanged;
		}
   }
}