﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using System.Windows.Forms;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Controls.Events
{
	public static class LayerChipControlEvent
	{
		public static void Initialize(LayerChipControl chipControl, EditorNotify editor, StageNotify stage)
		{
			chipControl.ChipPropertyChanged += (sender, e) =>
				ChipsetInstance.SetProperty(editor.CurrentChip, e.ChipProperty);

			stage.PropertyChanged += chipControl.MapData_PropertyChanged;
			editor.PropertyChanged += chipControl.EditorData_PropertyChanged;
		}
   }
}