﻿using System;
using System.Collections.Generic;
using System.IO;

namespace Nlgp1.Common {
	/// <summary>
	/// レイヤを表すクラス
	/// </summary>
	public class LayerData {
		/// <summary>
		/// レイヤを初期化します。
		/// </summary>
		/// <param name="name">レイヤ名</param>
		public LayerData( string name ) {
			this.Name = name;
		}
		/// <summary>
		/// レイヤを初期化します。
		/// </summary>
		/// <param name="name">レイヤ名</param>
		/// <param name="chipsetPath">チップセットへのパス</param>
		/// <param name="chipsetImagePath">イメージへのパス</param>
		/// <param name="chips">すべてのチップ</param>
		/// <param name="map">マップ</param>
		public LayerData( string name , string chipsetPath , string chipsetImagePath , SortedDictionary< int , LayerChipData > chipTable , LayerChipData[,] map ) {
			this.Name = name;
			this.ChipsetPath = chipsetPath;
			this.ChipsetImagePath = chipsetImagePath;
			this.ChipTable = chipTable;
			this.Map = map;
		}

		/// <summary>
		/// レイヤ名
		/// </summary>
		public string Name {
			get;
			private set;
		}
		/// <summary>
		/// チップセットへのパス
		/// </summary>
		public string ChipsetPath {
			get;
			set;
		}
		/// <summary>
		/// イメージへのパス
		/// </summary>
		public string ChipsetImagePath {
			get;
			set;
		}
		/// <summary>
		/// すべてのチップ
		/// </summary>
		public SortedDictionary< int , LayerChipData > ChipTable {
			get;
			set;
		}
		public IEnumerable< LayerChipData > Chips {
			get {
				return this.ChipTable.Values;
			}
		}
		/// <summary>
		/// マップ
		/// </summary>
		public LayerChipData[,] Map {
			get;
			set;
		}

		public override string ToString() {
			return this.Name;
		}
	}
}
