﻿using System;

namespace Nlgp1.Common {
	/// <summary>
	/// チップを表すクラス
	/// </summary>
	public class LayerChipData {
		/// <summary>
		/// チップのサイズ
		/// </summary>
		public static readonly int SizeSide = 32;

		/// <summary>
		/// Chipクラスの新しいインスタンスを初期化します。
		/// </summary>
		/// <param name="index">種類を表すための識別番号</param>
		public LayerChipData( int index ) {
			this.Index = index;
		}
		/// <summary>
		/// Chipクラスの新しいインスタンスを初期化します。
		/// </summary>
		/// <param name="index">種類を表すための識別番号</param>
		/// <param name="name">チップの種類を識別する名前</param>
		/// <param name="friction">摩擦</param>
		/// <param name="flags">チップに適応する属性</param>
		/// <param name="comment">チップの説明文</param>
		public LayerChipData( int index , string name , string comment , LayerChipType flags , double friction ) {
			this.Index = index;
			this.Name = name;
			this.Summary = comment;
			this.Type = flags;
			this.Friction = friction;
		}

		/// <summary>
		/// チップの種類を表す番号を取得します。
		/// </summary>
		public int Index {
			get;
			private set;
		}
		/// <summary>
		/// チップの種類を識別する名前を取得します。
		/// </summary>
		public string Name {
			get;
			set;
		}
		/// <summary>
		/// チップの説明文を取得します。
		/// </summary>
		public string Summary {
			get;
			set;
		}
		/// チップの属性を取得します。
		/// </summary>
		public LayerChipType Type {
			get;
			set;
		}
		/// <summary>
		/// 摩擦
		/// </summary>
		/// <summary>
		public double Friction {
			get;
			set;
		}
		/// <summary>
		/// チップ名を取得します。
		/// </summary>
		/// <returns></returns>
		public override string ToString() {
			return Name;
		}
	}
}
