﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Common;
using Box2DX.Dynamics;
using Box2DX.Collision;
namespace Nlgp1.B2DX
{
	public class Polygondef2 : PolygonDef
	{
		/*
		public Polygondef2(float fric, float rest, float dens)
		{
			Density = dens;
			Friction = fric;
			Restitution = rest;
		}
		*/
		/// <summary>
		/// 物質の状態を決めます
		/// </summary>
		/// <param name="fric">摩擦です、大きければ大きいほど、物質がこの上で滑りにくくなります</param>
		/// <param name="rest">反発です、2くらいでかなり良く跳ね返るようになります</param>
		/// <param name="dens">密度です、箱の大きさとこの値から質量等が導かれます</param>
		/// <param name="u">ユーザーデータです、詳しくはUserDataにて</param>
		public Polygondef2(float fric, float rest, float dens,myUserData u){
			Density = dens;
			Friction = fric;
			Restitution = rest;
			User = u;
			Filter = u.filter;
		}
		public void Fil()
		{
			FilterData f = new FilterData();
			f.CategoryBits = 0x1;
			f.MaskBits = 0x1;
			f.GroupIndex = 0x1;
			this.Filter = f;
			
		}
		/// <summary>
		/// フィルターデータ、2進法で入力する
		/// </summary>
		/// <param name="cat">カテゴリービット</param>
		/// <param name="mask">マスクビット</param>
		/// <param name="grou">グループ</param>
		public void Fil(string cat, string mask, string grou)
		{
			FilterData f = new FilterData();
			f.CategoryBits = Convert.ToUInt16(cat,2);
			f.MaskBits = Convert.ToUInt16(mask,2);
			f.GroupIndex = Convert.ToInt16(grou,2);
			this.Filter = f;
			User.filter=f;
		}
		myUserData user;
		public myUserData User
		{
			get
			{
				return user;
			}
			set
			{
				user = value;
			}
		}
		/// <summary>
		/// 何を入れるか未定
		/// </summary>
		public void SetUser()
		{
		}

	}

}