﻿using System;
using System.Collections.Generic;

using System.Text;
using DxLibDLL;
using Box2DX.Dynamics;
using Box2DX.Common;
using Box2DX.Collision;

namespace Nlgp1.B2DX
{
	public class Debug:DebugDraw
	{
		public static void Drawline(Segment s, Colors c)
		{
			DX.COLOR_U8 col;
			switch (c)
			{
				case Colors.Blue:
					col = new DX.COLOR_U8(0x0000FF);
					break;
				case Colors.Red:
					col = new DX.COLOR_U8(0xFF0000);
					break;
				default:
					throw new Exception("未定義の色です" + c.ToString());

			}
			Vec2 p1=s.P1,p2=s.P2; 
			DX.DrawLine((int)p1.X,(int)p1.Y,(int)p2.X,(int)p2.Y,col);
		}
		public static void PrintContact(Vec2 pos)
		{
			DX.DrawLine((int)pos.X - 5, (int)pos.Y - 5, (int)pos.X + 5, (int)pos.Y + 5, new DX.COLOR_U8(0xFF0000));
			DX.DrawLine((int)pos.X + 5, (int)pos.Y - 5, (int)pos.X - 5, (int)pos.Y + 5, new DX.COLOR_U8(0xFF0000));
		}

		public static void DebugHit(string colname)
		{
			DX.DrawString(2, 300, colname, new DX.COLOR_U8(0xFFFFFF));
		}

		public override void DrawCircle(Box2DX.Common.Vec2 center, float radius, Color color)
		{
			DX.DrawCircle((int)center.X, (int)center.Y, (int)radius,new DX.COLOR_U8(0xffffff));
		}

		public override void DrawPolygon(Box2DX.Common.Vec2[] vertices, int vertexCount, Color color)
		{
			for (int i = 0; i < vertexCount - 1; i++)
			{
				DX.DrawLine((int)vertices[i].X, (int)vertices[i].Y, (int)vertices[i + 1].X, (int)vertices[i + 1].Y, new DX.COLOR_U8(0xffffff));
			}
			DX.DrawLine((int)vertices[vertexCount].X, (int)vertices[vertexCount].Y, (int)vertices[0].X, (int)vertices[0].Y, new DX.COLOR_U8(0xffffff));
		}
		public override void DrawSegment(Box2DX.Common.Vec2 p1, Box2DX.Common.Vec2 p2, Color color)
		{
			//throw new NotImplementedException();
		}

		public override void DrawSolidCircle(Box2DX.Common.Vec2 center, float radius, Box2DX.Common.Vec2 axis, Color color)
		{
			DX.DrawCircle((int)center.X, (int)center.Y, (int)radius, new DX.COLOR_U8(0x11ffff),false);
		}

		public override void DrawSolidPolygon(Box2DX.Common.Vec2[] vertices, int vertexCount, Color color)
		{
			
			for (int i = 0; i < vertexCount - 1; i++)
			{
				DX.DrawLine((int)vertices[i].X, (int)vertices[i].Y, (int)vertices[i + 1].X, (int)vertices[i + 1].Y, new DX.COLOR_U8(0x00ffff));
			}
			DX.DrawLine((int)vertices[vertexCount-1].X, (int)vertices[vertexCount-1].Y, (int)vertices[0].X, (int)vertices[0].Y, new DX.COLOR_U8(0x00ffff));
		}

		public override void DrawXForm(Box2DX.Common.XForm xf)
		{
			//throw new NotImplementedException();
		}
	}
}
