﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Collision;
using Box2DX.Common;
using Box2DX.Dynamics;

namespace Nlgp1.B2DX
{
	class Bodydef2:BodyDef
	{
		myUserData ud;
		public myUserData MyUserData
		{
			get
			{
				return ud;
			}
			set
			{
				ud = value;
			}
		}
		
		/// <summary>
		/// コンストラクタのついたBodydef
		/// </summary>
		/// <param name="pos">位置</param>
		/// <param name="angle">角度</param>
		/// <param name="lid">加速減衰率</param>
		/// <param name="anD">角速度減衰率</param>
		/// <param name="md">重量、慣性などMassData</param>
		/// <param name="mud">Userdata</param>
		public Bodydef2(Vec2 pos ,float angle,float lid,float anD,MassData md,myUserData mud){
			this.Position=pos;
			this.Angle = angle;
			this.LinearDamping = lid;
			this.AngularDamping = anD;
			this.MassData = md;
			this.FixedRotation = true;
			this.UserData = mud;
		}
		/// <summary>
		/// コンストラクタのついたBodydef
		/// </summary>
		/// <param name="pos">位置</param>
		/// <param name="angle">角度</param>
		/// <param name="lid">加速減衰率</param>
		/// <param name="anD">角速度減衰率</param>
		/// <param name="mud">Userdata</param>
		public Bodydef2(Vec2 pos, float angle, float lid, float anD)
		{
			this.Position = pos;
			this.Angle = angle;
			this.LinearDamping = lid;
			this.AngularDamping = anD;
			this.FixedRotation = true;
		}


	}
}
