﻿using System;
using System.Collections.Generic;
using System.Text;
using DxLibDLL;
using Nlgp1.B2DX;
using Box2DX.Dynamics.Controllers;
using Box2DX.Collision;
using Box2DX.Dynamics;
using Box2DX.Common;

namespace Nlgp1.B2DX
{
	class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		public static void Main()
		{
			DX.SetWindowSize(512, 384);
			DX.ChangeWindowMode(true);
			DX.DxLib_Init();
			const float pi=(float)System.Math.PI;

			World world = new World(new AABB
			{
				LowerBound = new Vec2(0, 0),
				UpperBound = new Vec2(512, 384),
			}, new Vec2(0, 9.8f), false);

			Debug dd = new Debug
			{
				Flags = DebugDraw.DrawFlags.Shape
			};
			world.SetDebugDraw(dd);

			world.SetContactListener(new CevTest());
			
			float friction = 0, density = 2, restitution = 0;
			//angularDampingは角速度減衰率, lineardampingは速度減衰率です
			//angularDampingが高くなると回りにくくなり、回転がすぐ止まるようになります
			float angularDamping = 0.3f, lineardamping = 0.5f, fric2 = 0.4f, rest2 = 0f, dens2 = 1;
			FilterData f = new FilterData();
			//接触判定する・しないを決められるフラグです、2進法で表しますが、気にしないでください
			f.CategoryBits = 1;
			f.GroupIndex = 1; f.MaskBits = 1;
			DynamicRigid d2 = new DynamicRigid(new Vec2(50, 60), 45 * pi / 180, lineardamping, angularDamping);
			d2.SetAsBox(16, 32, new Polygondef2(fric2, rest2, dens2, new myUserData("player", 1, f, 2, d2)), false);
			//以下の4行は飛び出ている方のBoxの定義です、コメントアウトするとなくなります
			/*
			Polygondef2 d2p = new Polygondef2(friction, restitution, density, new myUserData("d2p", 3, f, 2));
			d2p.SetAsBox(24, 12, new Vec2(-20, 1), 0);
			d2p.Fil();
			d2.Addtolist(d2p);
			*/
			d2.NoRotate = true;
			d2.MakeBody(world);
			//床の定義です
			StaticRigid ground = new StaticRigid(new Vec2(250, 350), 0, 0, 0);
			ground.SetAsBox(250, 25, new Polygondef2(3, 3,//ここを3にするとはね回ります
				 0, new myUserData()), false);
			ground.MakeBody(world);

			StaticRigid sail = new StaticRigid(new Vec2(250, 120), 0, 0, 0);
			sail.SetAsBox(250, 25, new Polygondef2(3, 0, 0, new myUserData("sail", 0, f, 2, sail)), false);
			sail.MakeBody(world);
			//Joints joints = new Joints(d1.SelfBody, d2.SelfBody);
			//world.CreateJoint(joints.MakeDistanceJoint());

			DX.SetDrawScreen(DX.DX_SCREEN_BACK);
			
			while (DX.ProcessMessage())
			{
				#region ローカル変数
				float deltatime = 1 / 60f;
				#endregion
				if (DX.CheckHitKey(DX.KEY_INPUT.A)) deltatime = 1 / 120f;
				DX.ClearDrawScreen();
				

				DX.DrawString(2, 27, d2.SelfBody.GetPosition().X.ToString() + ", " + d2.SelfBody.GetPosition().Y.ToString(), new DX.COLOR_U8(0xffffff));

				world.Step(deltatime, 8, 1);

				DX.ScreenFlip();

			}
			DX.DxLib_End();
		}
	}
}

