using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class NetWork : Handler< NetWork >
		{

			internal static NetWork FromHandle( int handle )
			{
				NetWork handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{
					handler = new NetWork( handle ) ;
					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			private NetWork( int handle ) : base( handle )
			{
			}

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_CloseNetWork( handle ) ;
				}
			}

			/// <summary> ڑI </summary>
		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			private static extern int dx_CloseNetWork( int NetHandle ) ;
		}

		/// <summary> ڑI </summary>
		public static void CloseNetWork( NetWork NetHandle )
		{
			Disposable.Dispose( NetHandle ) ;
		}
	}
}
