using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class Music : Handler< Music >
		{

			internal static Music FromHandle( int handle )
			{
				Music handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{
					handler = new Music( handle ) ;
					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			private Music( int handle ) : base( handle )
			{
			}

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_DeleteMusicMem( handle ) ;
				}
			}

		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			private static extern int dx_DeleteMusicMem( int MusicHandle ) ;
		}

		/// <summary> lhchnh폜 </summary>
		public static void DeleteMusicMem( Music MusicHandle )
		{
			Disposable.Dispose( MusicHandle ) ;
		}
	}
}
