using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class Graph : Handler< Graph >
		{

			internal static Graph FromHandle( int handle )
			{
				Graph handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{

					switch( handle )
					{
					case DX_SCREEN_TEMPFRONT :
					case DX_SCREEN_FRONT :
					case DX_SCREEN_WORK :
					case DX_SCREEN_BACK :
						handler = new Graph( handle, true ) ;
						break ;
					default :
						handler = new Graph( handle ) ;
						break ;
					}

					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			internal static Graph[] FromHandleArray( int[] handles )
			{
				if( handles != null )
				{
					Graph[] handlers = new Graph[ handles.Length ] ;

					for( int i = 0 ; i < handlers.Length ; i ++ )
					{
						handlers[ i ] = Graph.FromHandle( handles[ i ] ) ;
					}

					return handlers ;
				}
				else
				{
					return null ;
				}
			}

			private Graph( int handle ) : base( handle )
			{
			}

			private Graph( int handle, bool disposed ) : base( handle, disposed )
			{
			}


			internal const int DX_SCREEN_TEMPFRONT = unchecked( ( int )( 0xfffffffb ) ) ;

			internal const int DX_SCREEN_FRONT = unchecked( ( int )( 0xfffffffc ) ) ;

			internal const int DX_SCREEN_WORK = unchecked( ( int )( 0xfffffffd ) ) ;

			internal const int DX_SCREEN_BACK = unchecked( ( int )( 0xfffffffe ) ) ;

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_DeleteGraph( handle , DX.LogOutFlag ) ;
				}
			}

		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			private static extern int dx_DeleteGraph( int GrHandle , bool LogOutFlag ) ;
		}

		public static Graph DX_SCREEN_TEMPFRONT
		{
			get { return Graph.FromHandle( Graph.DX_SCREEN_TEMPFRONT ) ; }
		}

		public static Graph DX_SCREEN_FRONT
		{
			get { return Graph.FromHandle( Graph.DX_SCREEN_FRONT ) ; }
		}

		public static Graph DX_SCREEN_WORK
		{
			get { return Graph.FromHandle( Graph.DX_SCREEN_WORK ) ; }
		}

		public static Graph DX_SCREEN_BACK
		{
			get { return Graph.FromHandle( Graph.DX_SCREEN_BACK ) ; }
		}

		/// <summary> w̃OtBbNnh폜 </summary>
		public static void DeleteGraph( Graph GrHandle )
		{
			Graph.Dispose( GrHandle ) ;
		}
	}
}
