using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public abstract class Disposable : IDisposable
		{

			public static void Dispose( IDisposable disposable )
			{
				if( disposable != null )
				{
					disposable.Dispose() ;
				}
			}

			public void Dispose()
			{
				if( !this.disposed )
				{
					this.Destruct() ;
					this.Construct() ;
					this.disposed = true ;
					GC.SuppressFinalize( this ) ;
				}
			}

			~Disposable()
			{
				if( !this.disposed )
				{
					this.Destruct() ;
					this.disposed = true ;
				}
			}

			internal protected void SuppressDispose()
			{
				if( !this.disposed )
				{
					this.Construct() ;
					this.disposed = true ;
					GC.SuppressFinalize( this ) ;
				}
			}

			internal protected Disposable() : this( false )
			{
			}
			
			internal protected Disposable( bool disposed )
			{
				this.disposed = disposed ;

				if( this.disposed )
				{
					GC.SuppressFinalize( this ) ;
				}
			}

			internal protected abstract void Construct() ;

			internal protected abstract void Destruct() ;

			private bool disposed ;
		}
	}
}
