#include "Python.h"

#include <numpy/arrayobject.h>
#include <pygobject.h>
#include <gtk/gtk.h>
#include <cairo.h>

static PyObject *gdkpixbuf_get_pixels_array(PyObject *self, PyObject *args)
{
  PyObject *pixbuf_pyobject;
  PyArrayObject *array;
  GdkPixbuf *pixbuf;
  int dims[3] = { 0, 0, 3 };

  if (!PyArg_ParseTuple(args, "O", &pixbuf_pyobject))
    return NULL;

  pixbuf = GDK_PIXBUF(((PyGObject *)pixbuf_pyobject)->obj);

  dims[0] = gdk_pixbuf_get_height(pixbuf);
  dims[1] = gdk_pixbuf_get_width(pixbuf);

  if (gdk_pixbuf_get_has_alpha(pixbuf))
    dims[2] = 4;

  array = (PyArrayObject *)PyArray_FromDimsAndData(3, dims, PyArray_UBYTE,
						   (char *)gdk_pixbuf_get_pixels(pixbuf));
  if (array == NULL)
    return NULL;
 
  array->strides[0] = gdk_pixbuf_get_rowstride(pixbuf);
  Py_INCREF(pixbuf_pyobject);
  array->base = (PyObject *)pixbuf_pyobject;

  return PyArray_Return(array);
}

static PyObject *gtkwindow_set_input_shape(PyObject *self, PyObject *args)
{
  PyObject *gtkwindow_pyobject;
  PyObject *surface_pyobject;
  GtkWindow *window;
  cairo_surface_t *surface;
  cairo_region_t *region;

  if(!PyArg_ParseTuple(args, "OO", &gtkwindow_pyobject, &surface_pyobject))
    return NULL;

  window = GTK_WINDOW(((PyGObject *)gtkwindow_pyobject)->obj);
  surface = (cairo_surface_t *)(((PyGObject *)surface_pyobject)->obj);

  region = gdk_cairo_region_create_from_surface(surface); 
  gtk_widget_input_shape_combine_region(window, region);

  Py_RETURN_NONE;
}

static struct PyMethodDef gtkhack_methods[] = {
  {"gdkpixbuf_get_pixels_array", gdkpixbuf_get_pixels_array, METH_VARARGS},
  {"gtkwindow_set_input_shape", gtkwindow_set_input_shape, METH_VARARGS},
  {NULL, NULL} /* sentinel */
};

static struct PyModuleDef module_def = {
  PyModuleDef_HEAD_INIT,
  "_gtkhack",
  NULL,
  -1,
  gtkhack_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__gtkhack()
{
  _import_array();
  return PyModule_Create(&module_def);
}
