# -*- coding: utf-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2003-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import codecs
import logging


class Config(dict):

    def get_with_type(self, name, conv, default=None):
        value = self.get(name)
        if value is None:
            return default
        ##assert conv is not None
        try:
            return conv(value)
        except ValueError:
            return default # XXX

    def get(self, name, default=None):
        keylist = name if isinstance(name, list) else [name]
        for key in keylist:
            if key in self:
                return self[key]
        return default

    def __str__(self):
        return ''.join(
            ['{0},{1}\n'.format(key.encode('utf-8'),
                                value.encode('utf-8')) \
                 for key, value in self.items()])


def create_from_file(path):
    charset = 'Shift_JIS' # default
    with open(path) as f:
        if f.read(3) == codecs.BOM_UTF8:
            charset = 'UTF-8'
        else:
            f.seek(0) # rewind
        buf = [line.strip() for line in f if line.strip()]
    return create_from_buffer(buf, charset)

def create_from_buffer(buf, charset='Shift_JIS'):
    dic = Config()
    for line in buf:
        try:
            key, value = line.split(',', 1)
        except ValueError:
            continue
        key = key.strip()
        if key == 'charset':
            value = value.strip()
            try:
                codecs.lookup(value)
            except:
                logging.error('Unsupported charset {0}'.format(value))
            else:
                charset = value
        elif key in ['refreshundeletemask', 'icon', 'cursor',
                     'shiori', 'makoto']:
            dic[key] = value.strip()
        else:
            dic[key] = unicode(value, charset, 'replace').strip()
    return dic

def null_config():
    return Config()
