/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import net.morilib.sh.misc.XtraceStream;

public class ShTreeEval implements ShTree {

	private List<ShToken> line;

	public ShTreeEval(List<ShToken> line) {
		this.line = new ArrayList<ShToken>(line);
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.add(this);
	}

	public int eval(ShEnvironment env, ShFileSystem fs,
			ShBuiltInCommands cmds, ShRuntime run,
			InputStream stdin, PrintStream stdout, PrintStream stderr,
			XtraceStream prompt) throws IOException,
			ShSyntaxException {
		StringBuffer b = new StringBuffer();
		List<String> l;
		String d = "";
		ShLexer r;
		ShTree x;

		l = ShTrees.substituteCommand(env, cmds, run, fs, stderr,
				prompt, line);
		for(String s : l.subList(1, l.size())) {
			b.append(d).append(s);
			d = " ";
		}

		r = new ShLexer(new PushbackReader(new StringReader(
				b.toString())));
		x = ShParser.parseCommand(r, r.nextToken());
		return x.eval(env, fs, cmds, run, stdin, stdout, stderr,
				prompt);
	}

	public String toString() {
		StringBuffer b = new StringBuffer();

		b.append("eval");
		for(ShToken l : line)  b.append(' ').append(l);
		return b.toString();
	}

}
