/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.util.HashMap;
import java.util.Map;

import net.morilib.nina.translate.NinaTranslator;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class NinatOptions {

	private NinaTranslator translator;
	private Map<String, String> opts = new HashMap<String, String>();
	private String filename;

	/**
	 * @return the translator
	 */
	public NinaTranslator getTranslator() {
		return translator;
	}

	//
	void setTranslator(NinaTranslator translator) {
		this.translator = translator;
	}

	/**
	 * @return the filename
	 */
	public String getFilename() {
		return filename;
	}

	//
	void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public String getOption(String key) {
		return opts.get(key);
	}

	//
	void setOption(String key, String value) {
		opts.put(key, value);
	}

}
