/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import net.morilib.automata.DFAState;
import net.morilib.automata.NFAState;
import net.morilib.range.Interval;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class NinaTranslatorJava extends AbstractNinaTranslator {

	//
	private PrintWriter out = null;
	private String filename;
	private String classname;

	//
	private void printintv(Interval v, boolean els) {
		String s, t, a;

		s = v.isInfimumClosed() ? ">=" : ">";
		t = v.isSupremumClosed() ? "<=" : "<";
		a = els ? "\t\t\t} else if" : "\t\t\tif";
		out.format("%s(c %s %d && c %s %d) {\n",
				a, s, ((Integer)v.getInfimumBound()).intValue(),
				t, ((Integer)v.getSupremumBound()).intValue());
		
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.compiler.AbstractNinaTranslater#printState(net.morilib.automata.DFAState)
	 */
	@Override
	protected void printState(DFAState<Object, NFAState, Void> dfa) {
		DFAState<Object, NFAState, Void> d;
		int sn = getStateNo(dfa), c;
		boolean els = false;

		out.format("\t\tcase %d:\n", sn);
		for(Interval v : dfa.getAlphabetRanges()) {
			printintv(v, els);
			c = ((Integer)v.getInfimumBound()).intValue();
			if(v.isInfimumOpen())  c++;
			d = dfa.goInt(c);
			out.format("\t\t\t\tstate = %d;\n", getStateNo(d));
			els = true;
		}
		out.println("\t\t\t}");
		out.println("\t\t\tbreak;");
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.compiler.AbstractNinaTranslater#printHeader()
	 */
	@Override
	protected void printHeader() {
		out.println("/*");
		out.println(" * This class is generated by Nina");
		out.println(" */");
		out.format("public class %s {\n", classname);
		out.println();
		out.println("\tint state;");
		out.println();
		out.println("\tvoid step(int c) {");
		out.println("\t\tswitch(state) {");
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.compiler.AbstractNinaTranslater#printFooter()
	 */
	@Override
	protected void printFooter() {
		out.println("\t\t}");
		out.println();
		out.println("\t}");
		out.println();
		out.println("\tboolean isAccepted() {");
		out.print("\t\treturn (false ||\n\t\t");
		for(int i : getAcceptStates()) {
			out.format("state == %d ||\n\t\t", i);
		}
		out.println("false);");
		out.println("\t}");
		out.println();
		out.println("}");
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.AbstractNinaTranslator#openWriters(java.lang.String)
	 */
	@Override
	protected void openWriters(String name) throws IOException {
		File f = new File(name);
		char[] a;

		filename = f.getName();
		a = filename.toCharArray();
		a[0] = Character.toUpperCase(a[0]);
		classname = new String(a);
		out = new PrintWriter(
				new FileOutputStream(filename + ".java"), true);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.AbstractNinaTranslator#closeWriters()
	 */
	@Override
	protected void closeWriters() {
		if(out != null)  out.close();
	}

}
