/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unix.regex;

/**
 * 基本正規表現に構文エラーが合ったとに発生する例外です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class BasicPatternSyntaxException extends RuntimeException {

	/**
	 * 例外を生成します。
	 */
	public BasicPatternSyntaxException() {
		super();
	}

	/**
	 * 例外を生成します。
	 * 
	 * @param message メッセージ
	 */
	public BasicPatternSyntaxException(String message) {
		super(message);
	}

}
