/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFAState;
import net.morilib.automata.dfa.ConvertedRangeDFA;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaNFA;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public abstract class AbstractNinaTranslator
implements NinaTranslator {

	private int stateNo = 0;
	private Map<Object, Integer> states =
			new IdentityHashMap<Object, Integer>();
	private Set<Integer> accepts = new HashSet<Integer>();
	private Stack<DFAState<Object, NFAState, Void>> trz;

	/**
	 * 
	 */
	protected PrintWriter out;

	/**
	 * 
	 * @param dfa
	 */
	protected abstract void printState(
			DFAState<Object, NFAState, Void> dfa);

	/**
	 * 
	 */
	protected abstract void printHeader();

	/**
	 * 
	 */
	protected abstract void printFooter();

	/**
	 * 
	 * @return
	 */
	protected Set<Integer> getAcceptStates() {
		return Collections.unmodifiableSet(accepts);
	}

	/**
	 * 
	 * @param state
	 * @return
	 */
	protected int getStateNo(DFAState<Object, NFAState, Void> state) {
		if(states.containsKey(state)) {
			return states.get(state);
		} else {
			states.put(state, stateNo);
			if(state.isAccepted())  accepts.add(stateNo);
			trz.push(state);
			return stateNo++;
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.compiler.NinaTranslater#translate(java.io.Reader, java.io.PrintWriter)
	 */
	@Override
	public void translate(Reader rd,
			PrintWriter out) throws IOException {
		DFAState<Object, NFAState, Void> s;
		DFA<Object, NFAState, Void> d;
		NinaNFA n;

		n = Nina.compile(rd);
		d = ConvertedRangeDFA.convertDFA(n);
		trz = new Stack<DFAState<Object, NFAState, Void>>();

		this.out = out;
		printHeader();
		states.put(d.getInitialState(), stateNo++);
		trz.add(d.getInitialState());
		while(!trz.isEmpty()) {
			s = trz.pop();
			printState(s);
		}
		printFooter();
	}

}
