/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import net.morilib.automata.DFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.dfa.ConvertedDFA;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.regular.BasicRegex;
import net.morilib.nina.QuadroImpl;
import net.morilib.nina.NinaParser;
import junit.framework.TestCase;

public class NinaSubAutomataTest extends TestCase {

	static void mat(NinaPattern m, String s) {
		NinaMatcher x;

		x = m.matcher(s);
		assertTrue(x.matches());
	}

	static void nmt(NinaPattern m, String s) {
		NinaMatcher x;

		x = m.matcher(s);
		assertFalse(x.matches());
	}

	static void drv(String s, boolean pause) {
		DFA<Object, NFAState, Void> d;
		NinaNFA n;
		NFABuilder a;
		NinaParser m;
		BasicRegex b;
		Quadro q;
		Object o;

		q = QuadroImpl.read(s);
		a = new NFABuilder();
		m = new NinaParser(q, a);
		try {
			while((o = m.step()) == null) {
				if(pause) {
//					System.in.read();
					m.printTrace(System.out);
				}
			}
			n = (NinaNFA)o;
			System.out.print(n);
			d = ConvertedDFA.convertDFA(n);
			b = DFAs.convertToRegex(d);
			System.out.println(b);
			System.out.println("-------------------------------");
		} catch(Exception e) {
			m.printTrace(System.out);
			throw new RuntimeException(e);
		}
	}

	public void test0001() {
		String s =
				"#machine NFABuilder\n" +
				" =======                                @*****\n" +
				" =aaa  >--{/net/morilib/nina/t01.nina}-->aa  *\n" +
				" ==^====                                **v***\n" +
				"   \\--------------------b-----------------/  \n" +
				"";

		drv(s, false);
	}

	public void test0002() {
		String s =
				"#machine NFABuilder\n" +
				" =======                                @*****\n" +
				" =aaa  >--{/net/morilib/nina/t02.nina}-->aa  *\n" +
				" =======                                ******\n" +
				"";

		drv(s, false);
	}

	public void test0003() throws Exception {
		NinaPattern m;

		m = Nina.patternResource("/net/morilib/nina/t03.nina");
		mat(m, "1");
		mat(m, "1+2");
		mat(m, "1+2+3");
		mat(m, "1+2*3+3");
	}

}
