/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Element;

import static jp.ossc.nimbus.TestUtility.*;
import jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData;

/**
 * {@link DefaultLogMetaData}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class DefaultLogMetaDataTest{

    @DataProvider(name = "DefaultLogMetaData")
    public Object[][] dataDefaultLogMetaData(){
        return new Object[][]{
            {null},
            {new NimbusMetaData(null, null)},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#DefaultLogMetaData(jp.ossc.nimbus.core.MetaData)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*"},
          dataProvider = "DefaultLogMetaData")
    public void testDefaultLogMetaData(MetaData parent){
        DefaultLogMetaData metaData = new DefaultLogMetaData(parent);
        assertEquals(metaData.getParent(), parent);
    }

    @DataProvider(name = "SetDebug")
    public Object[][] dataSetDebug(){
        return new Object[][]{
            {null},
            {new LogCategoryMetaData(null)}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#setDebug(jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData#getDebug()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetDebug")
    public void testSetDebug(LogCategoryMetaData logData){
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.setDebug(logData);
        assertEquals(metaData.getDebug(), logData);
    }

    @DataProvider(name = "SetInformation")
    public Object[][] dataSetInformation(){
        return new Object[][]{
            {null},
            {new LogCategoryMetaData(null)}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#setInformation(jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData#getInformation()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetInformation")
    public void testSetInformation(LogCategoryMetaData logData){
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.setInformation(logData);
        assertEquals(metaData.getInformation(), logData);
    }

    @DataProvider(name = "SetWarning")
    public Object[][] dataSetWarning(){
        return new Object[][]{
            {null},
            {new LogCategoryMetaData(null)}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#setWarning(jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData#getWarning()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetWarning")
    public void testSetWarning(LogCategoryMetaData logData){
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.setWarning(logData);
        assertEquals(metaData.getWarning(), logData);
    }

    @DataProvider(name = "SetError")
    public Object[][] dataSetError(){
        return new Object[][]{
            {null},
            {new LogCategoryMetaData(null)}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#setError(jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData#getError()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetError")
    public void testSetError(LogCategoryMetaData logData){
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.setError(logData);
        assertEquals(metaData.getError(), logData);
    }

    @DataProvider(name = "SetFatal")
    public Object[][] dataSetFatal(){
        return new Object[][]{
            {null},
            {new LogCategoryMetaData(null)}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#setFatal(jp.ossc.nimbus.core.DefaultLogMetaData.LogCategoryMetaData)",
                    "jp.ossc.nimbus.core.DefaultLogMetaData#getFatal()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetFatal")
    public void testSetFatal(LogCategoryMetaData logData){
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.setFatal(logData);
        assertEquals(metaData.getFatal(), logData);
    }

    @DataProvider(name = "ImportXML")
    public Object[][] dataImportXML() throws Exception{
        return new Object[][]{
            {createElement("<default-log/>"), new Object[]{null, null, null, null, null}},
            {
                createElement("<default-log><debug output=\"true\"/></default-log>"),
                new Object[]{importXML(new LogCategoryMetaData(null), "<debug output=\"true\"/>"), null, null, null, null}
            },
            {
                createElement("<default-log><information output=\"true\"/></default-log>"),
                new Object[]{null, importXML(new LogCategoryMetaData(null), "<information output=\"true\"/>"), null, null, null}
            },
            {
                createElement("<default-log><warning output=\"true\"/></default-log>"),
                new Object[]{null, null, importXML(new LogCategoryMetaData(null), "<warning output=\"true\"/>"), null, null}
            },
            {
                createElement("<default-log><error output=\"true\"/></default-log>"),
                new Object[]{null, null, null, importXML(new LogCategoryMetaData(null), "<error output=\"true\"/>"), null}
            },
            {
                createElement("<default-log><fatal output=\"true\"/></default-log>"),
                new Object[]{null, null, null, null, importXML(new LogCategoryMetaData(null), "<fatal output=\"true\"/>")}
            },
            {
                createElement("<default-log><debug output=\"true\"/><information output=\"true\"/><warning output=\"true\"/><error output=\"true\"/><fatal output=\"true\"/></default-log>"),
                new Object[]{
                    importXML(new LogCategoryMetaData(null), "<debug output=\"true\"/>"),
                    importXML(new LogCategoryMetaData(null), "<information output=\"true\"/>"),
                    importXML(new LogCategoryMetaData(null), "<warning output=\"true\"/>"),
                    importXML(new LogCategoryMetaData(null), "<error output=\"true\"/>"),
                    importXML(new LogCategoryMetaData(null), "<fatal output=\"true\"/>")
                }
            },
            {createElement("<default-log unknown=\"hoge\"/>"), new Object[]{null, null, null, null, null}},
            {createElement("<default-log><unknown/></default-log>"), new Object[]{null, null, null, null, null}},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#importXML(org.w3c.dom.Element)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#getDebug\\(\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#getInformation\\(\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#getWarning\\(\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#getError\\(\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#getFatal\\(\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#LogCategoryMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#importXML\\(org\\.w3c\\.dom\\.Element\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData\\.LogCategoryMetaData#toXML\\(java\\.lang\\.StringBuilder\\)"},
          dataProvider = "ImportXML")
    public void testImportXML(
        Element element,
        Object[] assertValues
    ) throws DeploymentException{
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.importXML(element);
        assertMetaDataEquals(metaData.getDebug(), (MetaData)assertValues[0]);
        assertMetaDataEquals(metaData.getInformation(), (MetaData)assertValues[1]);
        assertMetaDataEquals(metaData.getWarning(), (MetaData)assertValues[2]);
        assertMetaDataEquals(metaData.getError(), (MetaData)assertValues[3]);
        assertMetaDataEquals(metaData.getFatal(), (MetaData)assertValues[4]);
    }

    @DataProvider(name = "ImportXMLError")
    public Object[][] dataImportXMLError() throws Exception{
        return new Object[][]{
            {null},
            {createElement("<hoge/>")},
            {createElement("<default-log><debug output=\"true\"/><debug output=\"true\"/></default-log>")},
            {createElement("<default-log><information output=\"true\"/><information output=\"true\"/></default-log>")},
            {createElement("<default-log><warning output=\"true\"/><warning output=\"true\"/></default-log>")},
            {createElement("<default-log><error output=\"true\"/><error output=\"true\"/></default-log>")},
            {createElement("<default-log><fatal output=\"true\"/><fatal output=\"true\"/></default-log>")},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#importXML(org.w3c.dom.Element)",
                    "Error"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          expectedExceptions = {NullPointerException.class, DeploymentException.class},
          dataProvider = "ImportXMLError")
    public void testImportXMLError(Element element) throws DeploymentException{
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.importXML(element);
    }

    @DataProvider(name = "ToXML")
    public Object[][] dataToXML() throws Exception{
        return new Object[][]{
            {createElement("<default-log/>"), "<default-log></default-log>"},
            {createElement("<default-log></default-log>"), "<default-log></default-log>"},
            {createElement("<default-log><debug output=\"true\"/><information output=\"true\"/></default-log>"), "<default-log>" + System.getProperty("line.separator") + "    <debug output=\"true\"/>" + System.getProperty("line.separator") + "    <information output=\"true\"/>" + System.getProperty("line.separator") + "</default-log>"},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultLogMetaData#toXML(java.lang.StringBuilder)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#DefaultLogMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.DefaultLogMetaData#importXML\\(org\\.w3c\\.dom\\.Element\\)"},
          dataProvider = "ToXML")
    public void testToXML(Element element, String expected) throws DeploymentException{
        DefaultLogMetaData metaData = new DefaultLogMetaData(null);
        metaData.importXML(element);
        StringBuilder buf = new StringBuilder();
        metaData.toXML(buf);
        assertEquals(buf.toString(), expected);
    }
}
