/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * NullRo[^B<p>
 * nullQƂCӂ̃IuWFNgɕϊB<br>
 * 
 * @author M.Takata
 */
public class NullConverter implements ReversibleConverter, java.io.Serializable{
    
    private static final long serialVersionUID = -5603437969416832007L;
    
    /**
     * nullIuWFNg\ϊʒ萔B<p>
     */
    public static final int NULL_TO_OBJECT = POSITIVE_CONVERT;
    
    /**
     * IuWFNgnull\ϊʒ萔B<p>
     */
    public static final int OBJECT_TO_NULL = REVERSE_CONVERT;
    
    /**
     * ϊʁB<p>
     */
    protected int convertType;
    
    /**
     * nullQƂɑΉIuWFNgB<p>
     */
    protected Object nullObject;
    
    /**
     * nullIuWFNgϊ̃LN^Ro[^𐶐B<p>
     */
    public NullConverter(){
        this(NULL_TO_OBJECT);
    }
    
    /**
     * w肳ꂽϊʂ̕Ro[^𐶐B<p>
     *
     * @param type ϊ
     * @see #NULL_TO_OBJECT
     * @see #OBJECT_TO_NULL
     */
    public NullConverter(int type){
        setConvertType(type);
    }
    
    /**
     * ϊʂݒ肷B<p>
     *
     * @param type ϊ
     * @see #getConvertType()
     * @see #NULL_TO_OBJECT
     * @see #OBJECT_TO_NULL
     */
    @Override
    public void setConvertType(int type){
        convertType = type;
        switch(convertType){
        case NULL_TO_OBJECT:
        case OBJECT_TO_NULL:
            break;
        default:
            throw new IllegalArgumentException(
                "Invalid convert type : " + type
            );
        }
    }
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * nullQƂɑΉIuWFNgݒ肷B<p>
     *
     * @param obj IuWFNg
     */
    public void setNullObject(Object obj){
        nullObject = obj;
    }
    
    /**
     * nullQƂɑΉIuWFNg擾B<p>
     *
     * @return IuWFNg
     */
    public Object getNullObject(){
        return nullObject;
    }
    
    /**
     * nullQƂɑΉbooleanݒ肷B<p>
     *
     * @param na nullQƂɑΉboolean
     */
    public void setNullBoolean(Boolean na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉcharݒ肷B<p>
     *
     * @param na nullQƂɑΉchar
     */
    public void setNullChar(Character na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉbyteݒ肷B<p>
     *
     * @param na nullQƂɑΉbyte
     */
    public void setNullByte(Byte na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉshortݒ肷B<p>
     *
     * @param na nullQƂɑΉshort
     */
    public void setNullShort(Short na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉintݒ肷B<p>
     *
     * @param na nullQƂɑΉint
     */
    public void setNullInt(Integer na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉlongݒ肷B<p>
     *
     * @param na nullQƂɑΉlong
     */
    public void setNullLong(Long na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉfloatݒ肷B<p>
     *
     * @param na nullQƂɑΉfloat
     */
    public void setNullFloat(Float na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉdoubleݒ肷B<p>
     *
     * @param na nullQƂɑΉdouble
     */
    public void setNullDouble(Double na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉBigIntegerݒ肷B<p>
     *
     * @param na nullQƂɑΉBigInteger
     */
    public void setNullBigInteger(BigInteger na){
        nullObject = na;
    }
    
    /**
     * nullQƂɑΉBigDecimalݒ肷B<p>
     *
     * @param na nullQƂɑΉBigDecimal
     */
    public void setNullBigDecimal(BigDecimal na){
        nullObject = na;
    }
    
    /**
     * w肳ꂽIuWFNgϊB<p>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{
        switch(convertType){
        case OBJECT_TO_NULL:
            if((obj == null && nullObject == null)
                || nullObject == obj
                || (nullObject != null && nullObject.equals(obj))){
                return null;
            }else{
                return obj;
            }
        case NULL_TO_OBJECT:
        default:
            if(obj == null){
                return nullObject;
            }else{
                return obj;
            }
        }
    }
}
