/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import jp.ossc.nimbus.service.crypt.Crypt;

/**
 * Í/Ro[^B<p>
 * 
 * @author M.Takata
 */
public class CryptStringConverter
 implements StringConverter, ReversibleConverter, java.io.Serializable{
    
    private static final long serialVersionUID = 1L;

    /**
     * Í\ϊʒ萔B<p>
     */
    public static final int ENCODE = POSITIVE_CONVERT;
    
    /**
     * \ϊʒ萔B<p>
     */
    public static final int DECODE = REVERSE_CONVERT;
    
    /**
     * ϊʁB<p>
     */
    protected int convertType;
    
    /**
     * ÍT[rXB<p>
     */
    protected Crypt crypt;
    
    /**
     * pfBOspfBORo[^𐶐B<p>
     */
    public CryptStringConverter(){
        this(ENCODE);
    }
    
    /**
     * w肳ꂽϊʂ̕pfBORo[^𐶐B<p>
     *
     * @param type ϊ
     * @see #ENCODE
     * @see #DECODE
     */
    public CryptStringConverter(int type){
        setConvertType(type);
    }
    
    // ReversibleConverterJavaDoc
    @Override
    public void setConvertType(int type){
        switch(type){
        case ENCODE:
        case DECODE:
            convertType = type;
            break;
        default:
            throw new IllegalArgumentException(
                "Invalid convert type : " + type
            );
        }
    }
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * ÍT[rXݒ肷B<p>
     *
     * @param crypt ÍT[rX
     */
    public void setCrypt(Crypt crypt){
        this.crypt = crypt;
    }
    
    /**
     * ÍT[rX擾B<p>
     *
     * @return ÍT[rX
     */
    public Crypt getCrypt(){
        return crypt;
    }
    
    // ConverterJavaDoc
    @Override
    public Object convert(Object obj) throws ConvertException{
        return convert(
            obj == null ? (String)null : 
                (String)(obj instanceof String ? obj : String.valueOf(obj))
        );
    }
    
    /**
     * ϊB<p>
     * ϊzƕϊLN^zgĕϊB<br>
     *
     * @param str ϊΏۂ̕ 
     * @return ϊ̕
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public String convert(String str) throws ConvertException{
        if(crypt == null || str == null || str.length() == 0){
            return str;
        }
        switch(convertType){
        case ENCODE:
            return crypt.doEncode(str);
        case DECODE:
        default:
            return crypt.doDecode(str);
        }
    }
}
