/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.servlet;

import java.io.*;
import java.lang.reflect.*;

import javax.servlet.*;

import jp.ossc.nimbus.beans.*;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;

/**
 * C^[Zv^`F[ĂяotB^B<p>
 * T[ubgtB^C^[Zv^`F[ĂяotB^NXłB<br>
 * AvP[VՕiƂāAT[ubgtB^쐬鎖΂΂B<br>
 * AT[ubgtB^web.xmlŒ`ł͌ĂA쐬T[ubgtB^ɁAlXȃp[^nCWFNV肷鎖łB܂AtB^ʂpX̐ݒAOvyьṽpXwxłȂB<br>
 * NimbusƂ̑gݍ킹ƂӖł́AtB^ƃT[rX̘AgeՂł͂ȂB<br>
 * ŁAT[ubgtB^̋@\C^[Zv^ɈϏ鎖ŁA̎_₦悤ɂB<br>
 * AvP[VՊJ҂́AT[ubgtB^JςɁAC^[Zv^J鎖ŁAOq̎_J\ɂȂB<br>
 * ̃T[ubgtB^ɂ́Aȉ̏p[^B<br>
 * <table border="1" width="90%">
 *     <tr bgcolor="#cccccc"><th>#</th><th>p[^</th><th>l̐</th><th>ftHg</th></tr>
 *     <tr><td>1</td><td>InterceptorChainListServiceName</td><td>{@link InterceptorChainList}C^tF[XT[rX̃T[rXݒ肷B</td><td></td></tr>
 *     <tr><td>1</td><td>UseThreadLocalInterceptorChain</td><td>{@link DefaultThreadLocalInterceptorChain}gp邩ǂݒ肷B<br>truew肵ꍇAgpBftHgtrueB</td><td></td></tr>
 * </table>
 * <p>
 * ȉɁAT[ubgtB^web.xml`B<br>
 * <pre>
 * &lt;filter&gt;
 *     &lt;filter-name&gt;InterceptorChainCallFilter&lt;/filter-name&gt;
 *     &lt;filter-class&gt;jp.ossc.nimbus.servlet.InterceptorChainCallFilter&lt;/filter-class&gt;
 *     &lt;init-param&gt;
 *         &lt;param-name&gt;InterceptorChainListServiceName&lt;/param-name&gt;
 *         &lt;param-value&gt;Nimbus#InterceptorChainList&lt;/param-value&gt;
 *     &lt;/init-param&gt;
 * &lt;/filter&gt;
 * 
 * &lt;filter-mapping&gt;
 *     &lt;filter-name&gt;InterceptorChainCallFilter&lt;/filter-name&gt;
 *     &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class InterceptorChainCallFilter implements Filter, Invoker{
    
    public static final String INIT_PARAM_NAME_INTERCEPTOR_CHAIN_LIST_SERVICE_NAME = "InterceptorChainListServiceName";
    
    public static final String INIT_PARAM_NAME_USE_THREAD_LOCAL_INTERCEPTOR_CHAIN = "UseThreadLocalInterceptorChain";
    
    protected boolean isUseThreadLocalInterceptorChain = true;
    
    protected InterceptorChain interceptorChain;
    
    /**
     * tB^̏sB<p>
     * p[^Ŏw肳ꂽ{@link InterceptorChainList}T[rX擾A{@link Invoker}ƂāAgݒ肷B<br>
     *
     * @param filterConfig tB^\
     * @exception ServletException tB^̏Ɏsꍇ
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException{
        final ServiceNameEditor editor = new ServiceNameEditor();
        
        String name = filterConfig.getInitParameter(
            INIT_PARAM_NAME_INTERCEPTOR_CHAIN_LIST_SERVICE_NAME
        );
        ServiceName interceptorChainListServiceName = null;
        if(name != null){
            editor.setAsText(name);
            interceptorChainListServiceName = (ServiceName)editor.getValue();
        }
        
        final String isUseStr = filterConfig.getInitParameter(
            INIT_PARAM_NAME_USE_THREAD_LOCAL_INTERCEPTOR_CHAIN
        );
        if(isUseStr != null){
            isUseThreadLocalInterceptorChain
                = Boolean.valueOf(isUseStr).booleanValue();
        }
        
        if(interceptorChainListServiceName != null){
            if(isUseThreadLocalInterceptorChain){
                final DefaultThreadLocalInterceptorChain chain
                     = new DefaultThreadLocalInterceptorChain(
                        interceptorChainListServiceName,
                        null
                    );
                chain.setInvoker(this);
                interceptorChain = chain;
            }else{
                final DefaultInterceptorChain chain
                     = new DefaultInterceptorChain(
                        interceptorChainListServiceName,
                        null
                    );
                chain.setInvoker(this);
                interceptorChain = chain;
            }
        }
    }
    
    /**
     * tB^̔jsB<p>
     */
    @Override
    public void destroy(){
        interceptorChain = null;
    }
    
    /**
     * tB^sB<p>
     * p[^Ŏw肳ꂽ{@link InterceptorChainList}T[rXĂяoB<br>
     *
     * @param request NGXg
     * @param response X|X
     * @param chain tB^`F[
     */
    @Override
    public void doFilter(
        ServletRequest request,
        ServletResponse response,
        FilterChain chain
    ) throws IOException, ServletException{
        if(interceptorChain == null){
            chain.doFilter(request, response);
        }else{
            InterceptorChain localChain = interceptorChain;
            if(!isUseThreadLocalInterceptorChain){
                localChain = localChain.cloneChain();
            }
            try{
                localChain.setCurrentInterceptorIndex(-1);
                localChain.invokeNext(
                    new ServletFilterInvocationContext(request, response, chain)
                );
            }catch(IOException e){
                throw e;
            }catch(ServletException e){
                throw e;
            }catch(RuntimeException e){
                throw e;
            }catch(Error err){
                throw err;
            }catch(Throwable th){
                throw new UndeclaredThrowableException(th);
            }finally{
                localChain.setCurrentInterceptorIndex(-1);
            }
        }
    }
    
    /**
     * tB^`F[ĂяoB<p>
     *
     * @param context ĂяõReLXg
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    @Override
    public Object invoke(InvocationContext context) throws Throwable{
        final ServletFilterInvocationContext filterContext
             = (ServletFilterInvocationContext)context;
        filterContext.getFilterChain().doFilter(
            filterContext.getServletRequest(),
            filterContext.getServletResponse()
        );
        return null;
    }
}