/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import java.util.*;

import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DefaultWritableRecordFactoryService}MBeanC^tF[XB<p>
 * 
 * @author Y.Tokuda
 */
public interface DefaultWritableRecordFactoryServiceMBean extends ServiceBaseMBean {
    
    /**
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肳ꂽ}bṽL[ɑ΂WritableElementNXݒ肷B<p>
     * ̃\bhŐݒ肳ȂL[ɑ΂ẮA{@link SimpleElement}}bsOB<br>
     * 
     * @param key L[
     * @param clazz WritableElementNX
     */
    public void setWritableElementClass(String key, Class<WritableElement> clazz);
    
    /**
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肳ꂽ}bṽL[ɑ΂WritableElementNX擾B<p>
     * 
     * @param key L[
     * @return WritableElementNX
     */
    public Class<WritableElement> getWritableElementClass(String key);
    
    /**
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肳ꂽ}bṽL[ɑ΂WritableElementT[rXݒ肷B<p>
     * WritableElementCX^X́A̓sxKv̂ŁA{@link jp.ossc.nimbus.core.FactoryService FactoryService}T[rXgp邩Aservicevfinstancefactoryw肷邱ƁB<br>
     * ̃\bhŎw肳ȂL[ɑ΂ẮA{@link SimpleElement}}bsOB<br>
     * 
     * @param key L[
     * @param name WritableElementT[rX
     */
    public void setWritableElementServiceName(String key, ServiceName name);
    
    /**
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肳ꂽ}bṽL[ɑ΂WritableElementT[rX擾B<p>
     * 
     * @return WritableElementT[rX
     */
    public ServiceName getWritableElementServiceName(String key);
    
    /**
     * o̓tH[}bgݒ肷B<p>
     * tH[}bgɂ́AL[ƁAL[ȊO̔Cӂ̕gpłBL[̎ẃAL["%"ň͂ށB"%"L[̃Zp[^ȊO̕ƂĎgꍇ́A"\"OɕtăGXP[vB"\"GXP[vȊOƂĎgꍇ́A"\"2d˂B<br>
     * L[́A{@link WritableRecordFactory#createRecord(Object)}Ŏw肷MapȂ΁AMap̃L[̂܂܎w肷BCӂBeanłꍇ́AL[͒ۓIȖOƂA{@link #setFormatKeyProperty(String, Property)}ŁA   ̃L[Bean̂ǂ̂悤ȃvpeBlɂ邩ݒ肷B܂ABeañvpeBJԂ\ꍇɂ́AL[̌"*"t^BJԂ\̃tH[}bǵA{@link #setIterateFormat(String)}Ŏw肷B<br>
     * <pre>
     *  F[%DATE%] %MESSAGES*%
     * </pre>
     *
     * @param format tH[}bg
     */
    public void setFormat(String format);
    
    /**
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肳ꂽ}bv̒l̃tH[}bg擾B<p>
     *
     * @return tH[}bg
     */
    public String getFormat();
    
    /**
     * L[ɑ΂BeañvpeBݒ肷B<p>
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肷CӂBeanłꍇABeanǂ̂悤ɒl擾邩vpeBƂĐݒ肷B<br>
     * <pre>
     *  F
     *   Bean getDate() \bhꍇ
     *       &lt;attribute name="FormatKeyProperty(DATE)"&gt;Date&lt;/attribute&gt;
     *   Bean getMessageList() \bhꍇ
     *       &lt;attribute name="FormatKeyProperty(MESSAGES*)"&gt;MessageList&lt;/attribute&gt;
     * </pre>
     *
     * @param key L[
     * @param prop BeañvpeB
     */
    public void setFormatKeyProperty(String key, Property prop);
    
    /**
     * L[ɑ΂BeañvpeB擾B<p>
     *
     * @param key L[
     * @return BeañvpeB
     */
    public Property getFormatKeyProperty(String key);
    
    /**
     * L[ɑ΂BeañvpeBݒ肷B<p>
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肷CӂBeanłꍇABeanǂ̂悤ɒl擾邩vpeBƂĐݒ肷B<br>
     * <pre>
     *  F
     *   Bean getDate() \bhgetMessageList() \bhꍇ
     *       &lt;attribute name="FormatKeyProperty"&gt;
     *           DATE=Date
     *           MESSAGES*=MessageList
     *       &lt;/attribute&gt;
     * </pre>
     *
     * @param mapping JԂtH[}bgŎw肵L[ƃvpeB̃}bsO
     */
    public void setFormatKeyMapping(Properties mapping);
    
    /**
     * L[ɑ΂BeañvpeB擾B<p>
     *
     * @return tH[}bgŎw肵L[ƃvpeB̃}bsO
     */
    public Properties getFormatKeyMapping();
    
    /**
     * JԂ\̃tH[}bgݒ肷B<p>
     * tH[}bg̎w@́A{@link #setFormat(String)}ɏB<br>
     * <pre>
     *  F
     *    &lt;attribute name="IterateFormat(MESSAGES*)"&gt;%ID%:%MESSAGE%,&lt;/attribute&gt;
     * </pre>
     *
     * @param key JԂL[
     * @param format tH[}bg
     */
    public void setIterateFormat(String key, String format);
    
    /**
     * JԂ\̃tH[}bg擾B<p>
     *
     * @param key JԂL[
     * @return tH[}bg
     */
    public String getIterateFormat(String key);
    
    /**
     * JԂL[ɑ΂BeañvpeBݒ肷B<p>
     * {@link WritableRecordFactory#createRecord(Object)}Ŏw肷CӂBeanłꍇABeanǂ̂悤ɒl擾邩vpeBƂĐݒ肷B<br>
     * <pre>
     *  F
     *   JԂvfBean getId() \bhƁAgetMessage() \bhꍇ
     *       &lt;attribute name="IterateFormatKeyMapping(MESSAGES*)"&gt;
     *           ID=Id
     *           MESSAGE=Message
     *       &lt;/attribute&gt;
     * </pre>
     *
     * @param key JԂL[
     * @param mapping JԂtH[}bgŎw肵L[ƃvpeB̃}bsO
     */
    public void setIterateFormatKeyMapping(String key, Properties mapping);
    
    /**
     * JԂL[ɑ΂BeañvpeB擾B<p>
     *
     * @param key JԂL[
     * @return JԂtH[}bgŎw肵L[ƃvpeB̃}bsO
     */
    public Properties getIterateFormatKeyMapping(String key);
}
