/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.*;
import java.text.SimpleDateFormat;

/**
 * ftHgXPW[}X^B<p>
 *
 * @author M.Takata
 */
public class DefaultScheduleMaster
 implements ScheduleMaster, java.io.Serializable{
    
    private static final long serialVersionUID = -4016419359156060172L;
    
    protected String id;
    
    protected String taskName;
    
    protected String scheduleType;
    
    protected Object input;
    
    protected Date startTime;
    
    protected Date endTime;
    
    protected long repeatInterval;
    
    protected long retryInterval;
    
    protected Date retryEndTime;
    
    protected long maxDelayTime;
    
    protected boolean isEnabled = true;
    
    protected String[] depends;
    
    protected String executorKey;
    
    protected String executorType;
    
    /**
     * ̃CX^X𐶐B<p>
     */
    public DefaultScheduleMaster(){
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param id XPW[}X^ID
     * @param taskName ^XN
     * @param scheduleType ^XN
     * @param input ̓f[^
     * @param startTime Jn
     * @param isEnabled L/tO
     * @param depends ˑXPW[}X^ID̔z
     * @param executorKey ScheduleExecutor肷L[
     * @param executorType ScheduleExecutor̎
     */
    public DefaultScheduleMaster(
        String id,
        String taskName,
        String scheduleType,
        Object input,
        Date startTime,
        boolean isEnabled,
        String[] depends,
        String executorKey,
        String executorType
    ){
        this(
            id,
            taskName,
            scheduleType,
            input,
            startTime,
            null,
            0l,
            0l,
            null,
            0l,
            isEnabled,
            depends,
            executorKey,
            executorType
        );
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param id XPW[}X^ID
     * @param taskName ^XN
     * @param scheduleType ^XN
     * @param input ̓f[^
     * @param startTime Jn
     * @param retryInterval gCsԊu[ms]
     * @param retryEndTime gCI
     * @param maxDelayTime őx[ms]
     * @param isEnabled L/tO
     * @param depends ˑXPW[}X^ID̔z
     * @param executorKey ScheduleExecutor肷L[
     * @param executorType ScheduleExecutor̎
     */
    public DefaultScheduleMaster(
        String id,
        String taskName,
        String scheduleType,
        Object input,
        Date startTime,
        long retryInterval,
        Date retryEndTime,
        long maxDelayTime,
        boolean isEnabled,
        String[] depends,
        String executorKey,
        String executorType
    ){
        this(
            id,
            taskName,
            scheduleType,
            input,
            startTime,
            null,
            0l,
            retryInterval,
            retryEndTime,
            maxDelayTime,
            isEnabled,
            depends,
            executorKey,
            executorType
        );
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param id XPW[}X^ID
     * @param taskName ^XN
     * @param scheduleType ^XN
     * @param input ̓f[^
     * @param startTime Jn
     * @param endTime I
     * @param repeatInterval JԂsԊu[ms]
     * @param retryInterval gCsԊu[ms]
     * @param retryEndTime gCI
     * @param maxDelayTime őx[ms]
     * @param isEnabled L/tO
     * @param depends ˑXPW[}X^ID̔z
     * @param executorKey ScheduleExecutor肷L[
     * @param executorType ScheduleExecutor̎
     */
    public DefaultScheduleMaster(
        String id,
        String taskName,
        String scheduleType,
        Object input,
        Date startTime,
        Date endTime,
        long repeatInterval,
        long retryInterval,
        Date retryEndTime,
        long maxDelayTime,
        boolean isEnabled,
        String[] depends,
        String executorKey,
        String executorType
    ){
        setId(id);
        setTaskName(taskName);
        setScheduleType(scheduleType);
        setInput(input);
        setStartTime(startTime);
        setEndTime(endTime);
        setRepeatInterval(repeatInterval);
        setRetryInterval(retryInterval);
        setRetryEndTime(retryEndTime);
        setMaxDelayTime(maxDelayTime);
        setEnabled(isEnabled);
        setDepends(depends);
        setExecutorKey(executorKey);
        setExecutorType(executorType);
    }
    
    // ScheduleMasterJavaDoc
    public String getId(){
        return id;
    }
    
    /**
     * XPW[}X^IDݒ肷B<p>
     *
     * @param id XPW[}X^ID
     */
    public void setId(String id){
        this.id = id;
    }
    
    // ScheduleMasterJavaDoc
    public String getTaskName(){
        return taskName;
    }
    
    /**
     * XPW[ꂽ^XNݒ肷B<p>
     *
     * @param name ^XN
     */
    public void setTaskName(String name){
        taskName = name;
    }
    
    // ScheduleMasterJavaDoc
    public String getScheduleType(){
        return scheduleType;
    }
    
    /**
     * XPW[ꂽXPW[ʂݒ肷B<p>
     *
     * @param type XPW[
     */
    public void setScheduleType(String type){
        scheduleType = type;
    }
    
    // ScheduleMasterJavaDoc
    public Object getInput(){
        return input;
    }
    
    /**
     * XPW[̓̓f[^ݒ肷B<p>
     *
     * @param data ̓f[^
     */
    public void setInput(Object data){
        input = data;
    }
    
    // ScheduleMasterJavaDoc
    public Date getStartTime(){
        return startTime;
    }
    
    /**
     * XPW[Jnݒ肷B<p>
     *
     * @param time Jn
     */
    public void setStartTime(Date time){
        startTime = time;
    }
    
    // ScheduleMasterJavaDoc
    public Date getEndTime(){
        return endTime;
    }
    
    /**
     * XPW[Iݒ肷B<p>
     *
     * @param time I
     */
    public void setEndTime(Date time){
        endTime = time;
    }
    
    // ScheduleMasterJavaDoc
    public long getRepeatInterval(){
        return repeatInterval;
    }
    
    /**
     * XPW[JԂsԊu[ms]ݒ肷B<p>
     *
     * @param interval JԂsԊu
     */
    public void setRepeatInterval(long interval){
        repeatInterval = interval;
    }
    
    // ScheduleMasterJavaDoc
    public long getRetryInterval(){
        return retryInterval;
    }
    
    /**
     * XPW[gCsԊu[ms]ݒ肷B<p>
     *
     * @param interval gCsԊu
     */
    public void setRetryInterval(long interval){
        retryInterval = interval;
    }
    
    // ScheduleMasterJavaDoc
    public Date getRetryEndTime(){
        return retryEndTime;
    }
    
    /**
     * XPW[gCIݒ肷B<p>
     *
     * @param time gCI
     */
    public void setRetryEndTime(Date time){
        retryEndTime = time;
    }
    
    // ScheduleMasterJavaDoc
    public long getMaxDelayTime(){
        return maxDelayTime;
    }
    
    /**
     * XPW[̍őx[ms]ݒ肷B<p>
     *
     * @param time XPW[őx
     */
    public void setMaxDelayTime(long time){
        maxDelayTime = time;
    }
    
    // ScheduleMasterJavaDoc
    public boolean isEnabled(){
        return isEnabled;
    }
    
    // ScheduleMasterJavaDoc
    public void setEnabled(boolean isEnabled){
        this.isEnabled = isEnabled;
    }
    
    // ScheduleMasterJavaDoc
    public String[] getDepends(){
        return depends;
    }
    
    /**
     * ˑXPW[}X^IDݒ肷B<p>
     *
     * @param ids XPW[}X^ID̔z
     */
    public void setDepends(String[] ids){
        depends = ids;
    }
    
    // ScheduleMasterJavaDoc
    public void setExecutorKey(String key){
        executorKey = key;
    }
    
    // ScheduleMasterJavaDoc
    public String getExecutorKey(){
        return executorKey;
    }
    
    // ScheduleMasterJavaDoc
    public void setExecutorType(String type){
        executorType = type;
    }
    
    // ScheduleMasterJavaDoc
    public String getExecutorType(){
        return executorType;
    }
    
    // ScheduleMasterJavaDoc
    public void applyDate(Date date){
        final Calendar cal = Calendar.getInstance();
        if(startTime != null){
            startTime = applyDateToTime(date, startTime, cal);
        }
        if(endTime != null){
            endTime = applyDateToTime(date, endTime, cal);
        }
        if(retryEndTime != null){
            retryEndTime = applyDateToTime(date, retryEndTime, cal);
        }
    }
    
    /**
     * timedate̓tKpB<p>
     *
     * @param date t
     * @param time 
     * @param work ƗpJ_[
     * @return date̓ttime̎Date
     */
    protected Date applyDateToTime(Date date, Date time, Calendar work){
        work.clear();
        work.setTime(date);
        final int year = work.get(Calendar.YEAR);
        final int day = work.get(Calendar.DAY_OF_YEAR);
        work.clear();
        work.setTime(time);
        work.set(Calendar.YEAR, year);
        work.set(
            Calendar.DAY_OF_YEAR,
            day + (work.get(Calendar.DAY_OF_YEAR) - 1)
        );
        return work.getTime();
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    public int hashCode(){
        return id == null ? 0 : id.hashCode();
    }
    
    /**
     * w肳ꂽIuWFNg̃CX^XƓǂ𔻒肷B<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return w肳ꂽIuWFNg̃CX^XƓꍇtrue
     */
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj == this){
            return true;
        }
        if(!(obj instanceof ScheduleMaster)){
            return false;
        }
        ScheduleMaster cmp = (ScheduleMaster)obj;
        return (id == null && cmp.getId() == null)
            || (id != null && id.equals(cmp.getId()));
    }
    
    // ComparableJavaDoc
    public int compareTo(ScheduleMaster o){
        if(o == null){
            return -1;
        }
        if(o == this){
            return 0;
        }
        final ScheduleMaster cmp = o;
        if(startTime != null && cmp.getStartTime() == null){
            return -1;
        }
        if(startTime == null && cmp.getStartTime() != null){
            return 1;
        }
        if(startTime != null && cmp.getStartTime() != null){
            int result = startTime.compareTo(cmp.getStartTime());
            if(result != 0){
                return result;
            }
        }
        if(id == null && cmp.getId() == null){
            return 0;
        }
        if(id != null && cmp.getId() == null){
            return -1;
        }
        if(id == null && cmp.getId() != null){
            return 1;
        }
        return id.compareTo(cmp.getId());
    }
    
    /**
     * ̃CX^X̕\擾B<p>
     *
     * @return \
     */
    public String toString(){
        final SimpleDateFormat format
            = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
        final StringBuilder buf = new StringBuilder(super.toString());
        buf.append('{');
        buf.append("id=").append(id);
        buf.append(",taskName=").append(taskName);
        buf.append(",scheduleType=").append(scheduleType);
        buf.append(",input=").append(input);
        buf.append(",startTime=")
            .append(startTime == null ? null : format.format(startTime));
        buf.append(",endTime=")
            .append(endTime == null ? null : format.format(endTime));
        buf.append(",repeatInterval=").append(repeatInterval);
        buf.append(",retryInterval=").append(retryInterval);
        buf.append(",retryEndTime=")
            .append(retryEndTime == null ? null : format.format(retryEndTime));
        buf.append(",maxDelayTime=").append(maxDelayTime);
        buf.append(",isEnabled=").append(isEnabled);
        buf.append(",depends=");
        if(depends == null || depends.length == 0){
            buf.append((Object)null);
        }else{
            buf.append('[');
            for(int i = 0; i < depends.length; i++){
                buf.append(depends[i]);
                if(i != depends.length - 1){
                    buf.append(',');
                }
            }
            buf.append(']');
        }
        buf.append(",executorKey=").append(executorKey);
        buf.append(",executorType=").append(executorType);
        buf.append('}');
        return buf.toString();
    }
    
    public Object clone(){
        DefaultScheduleMaster master = null;
        try{
            master = (DefaultScheduleMaster)super.clone();
        }catch(CloneNotSupportedException e){
        }
        master.startTime = startTime == null ? null : (Date)startTime.clone();
        master.endTime = endTime == null ? null : (Date)endTime.clone();
        master.retryEndTime = retryEndTime == null ? null : (Date)retryEndTime.clone();
        return master;
    }
}