/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.io.Serializable;

/**
 * WzMNGXgB<p>
 * 
 * @author M.Takata
 */
public class ConcentrateRequest implements Serializable{
    
    private static final long serialVersionUID = -5534337631451607056L;
    
    /**
     * WzMʕFWB<p>
     */
    public static final String PROCESS_TYPE_GET = "GET";
    
    /**
     * WzMʕFzMB<p>
     */
    public static final String PROCESS_TYPE_PUT = "PUT";
    
    /**
     * WzMʁFWB<p>
     */
    public static final int PROCESS_TYPE_VALUE_GET = 1;
    
    /**
     * WzMʁFzMB<p>
     */
    public static final int PROCESS_TYPE_VALUE_PUT = 2;
    
    private String key;
    private String source;
    private String destination;
    private int processType;
    
    /**
     * ̃CX^X𐶐B<p>
     */
    public ConcentrateRequest(){
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param key L[
     * @param type WzM
     * @param src WzM
     * @param dest WzM
     * @see #PROCESS_TYPE_VALUE_GET
     * @see #PROCESS_TYPE_VALUE_PUT
     */
    public ConcentrateRequest(String key, int type, String src, String dest){
        this.key = key;
        source = src;
        destination = dest;
        processType = type;
    }
    
    /**
     * L[擾B<p>
     *
     * @return L[
     */
    public String getKey(){
        return key;
    }
    
    /**
     * L[ݒ肷B<p>
     *
     * @param key L[
     */
    public void setKey(String key){
        this.key = key;
    }
    
    /**
     * WzM擾B<p>
     *
     * @return WzM
     */
    public String getSource(){
        return source;
    }
    
    /**
     * WzMݒ肷B<p>
     *
     * @param src WzM
     */
    public void setSource(String src){
        source = src;
    }
    
    /**
     * WzM擾B<p>
     *
     * @return WzM
     */
    public String getDestination(){
        return destination;
    }
    
    /**
     * WzMݒ肷B<p>
     *
     * @param dest WzM
     */
    public void setDestination(String dest){
        destination = dest;
    }
    
    /**
     * WzMʂ擾B<p>
     *
     * @return WzM
     * @see #PROCESS_TYPE_VALUE_GET
     * @see #PROCESS_TYPE_VALUE_PUT
     */
    public int getProcessType(){
        return processType;
    }
    
    /**
     * WzMʂݒ肷B<p>
     *
     * @param type WzM
     * @see #PROCESS_TYPE_VALUE_GET
     * @see #PROCESS_TYPE_VALUE_PUT
     */
    public void setProcessType(int type){
        processType = type;
    }
    
    /**
     * WzMʂWzMʕɕϊB<p>
     *
     * @param type WzM
     * @return WzMʕ
     * @see #PROCESS_TYPE_VALUE_GET
     * @see #PROCESS_TYPE_VALUE_PUT
     * @see #PROCESS_TYPE_GET
     * @see #PROCESS_TYPE_PUT
     */
    public static String toProcessTypeString(int type){
        switch(type){
        case PROCESS_TYPE_VALUE_GET:
            return PROCESS_TYPE_GET;
        case PROCESS_TYPE_VALUE_PUT:
            return PROCESS_TYPE_PUT;
        default:
            return null;
        }
    }
    
    /**
     * WzMʕWzMʂɕϊB<p>
     *
     * @param type WzMʕ
     * @return WzM
     * @see #PROCESS_TYPE_GET
     * @see #PROCESS_TYPE_PUT
     * @see #PROCESS_TYPE_VALUE_GET
     * @see #PROCESS_TYPE_VALUE_PUT
     */
    public static int toProcessType(String type){
        if(type == null){
            return 0;
        }else if(PROCESS_TYPE_GET.equals(type.toUpperCase())){
            return PROCESS_TYPE_VALUE_GET;
        }else if(PROCESS_TYPE_PUT.equals(type.toUpperCase())){
            return PROCESS_TYPE_VALUE_PUT;
        }else{
            return 0;
        }
    }
}