/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

/**
 * Jakarta Commons Loggingp̃Ot@NgC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface CommonsLogFactory{
    
    /**
     * Ŏw肵NXIuWFNgɊ֘At{@link Log}CX^X擾B<p>
     *
     * @param clazz 擾LogCX^XʂL[ƂȂNXIuWFNg
     * @return Ŏw肵NXIuWFNgɊ֘At{@link Log}CX^X
     * @exception LogConfigurationException LogCX^X̍쐬Ɏsꍇ
     */
    public Log getInstance(Class<?> clazz) throws LogConfigurationException;
    
    /**
     * Ŏw肵OɊ֘At{@link Log}CX^X擾B<p>
     *
     * @param name 擾LogCX^Xʂ閼O
     * @return Ŏw肵OɊ֘At{@link Log}CX^X
     * @exception LogConfigurationException LogCX^X̍쐬Ɏsꍇ
     */
    public Log getInstance(String name) throws LogConfigurationException;
    
    /**
     * 쐬{@link Log}CX^XJB<p>
     */
    public void release();
    
    /**
     * l擾B<p>
     * "commons-logging.properties"Őݒ肵vpeBƂĊi[B<p>
     *
     * @param name 
     * @return l
     * @see #getAttributeNames()
     * @see #removeAttribute(String)
     * @see #setAttribute(String, Object)
     */
    public Object getAttribute(String name);
    
    /**
     * ̔z擾B<p>
     * "commons-logging.properties"Őݒ肵vpeBƂĊi[B<p>
     *
     * @return ̔z
     * @see #getAttribute(String)
     * @see #removeAttribute(String)
     * @see #setAttribute(String, Object)
     */
    public String[] getAttributeNames();
    
    /**
     * 폜B<p>
     * "commons-logging.properties"Őݒ肵vpeBƂĊi[B<p>
     *
     * @param name 
     * @return l
     * @see #getAttribute(String)
     * @see #getAttributeNames()
     * @see #setAttribute(String, Object)
     */
    public void removeAttribute(String name);
    
    /**
     * ݒ肷B<p>
     * "commons-logging.properties"Őݒ肵vpeBƂĊi[B<p>
     *
     * @param name 
     * @param value l
     * @see #getAttribute(String)
     * @see #getAttributeNames()
     * @see #removeAttribute(String)
     */
    public void setAttribute(String name, Object value);
}
