/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.*;
import javax.servlet.http.HttpSession;

import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * HttpSessionIuWFNgMaptH[}bgGfB^B<p>
 * ̃GfB^ɂĕҏWꂽMaṕAȉ̍\B<br>
 * <table broder="1">
 *   <tr bgcolor="#CCCCFF"><th colspan="2">L[</th><th colspan="5">l</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th colspan="4">e</th></tr>
 *   <tr><td rowspan="3">java.lang.String</td><td rowspan="3">{@link #ATTRIBUTES_KEY}</td><td rowspan="3">java.util.Map</td><td colspan="4">̃}bv</td></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th>e</th></tr>
 *   <tr><td>java.lang.String</td><td></td><td>java.lang.Object</td><td>l</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #ID_KEY}</td><td>java.lang.String</td><td colspan="4">ZbVID</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #CREATION_TIME_KEY}</td><td>java.util.Date</td><td colspan="4">ZbV쐬ꂽ</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #LAST_ACCESSED_TIME_KEY}</td><td>java.util.Date</td><td colspan="4">ZbVɊ֘AtꂽvNCAgŌɑM</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #MAX_INACTIVE_INTERVAL_KEY}</td><td>java.lang.Long</td><td colspan="4">ZbVۂő̎ԊԊu</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #IS_NEW_KEY}</td><td>java.lang.Boolean</td><td colspan="4">ZbVɎQĂ邩ǂ</td></tr>
 * </table>
 * AAo͂Ȃ悤ɐݒ肳Ă̂AHttpSessionɊ܂܂ĂȂAJ2EẼo[WɂĎ擾łȂ͊܂܂ȂB<br>
 * 
 * @author M.Takata
 */
public class HttpSessionMapJournalEditorService
 extends MapJournalEditorServiceBase
 implements HttpSessionMapJournalEditorServiceMBean, Serializable{
    
    private static final long serialVersionUID = 8651384368045906114L;
    
    private String[] secretAttributes;
    private Set<String> secretAttributeSet;
    private String[] enabledAttributes;
    private Set<String> enabledAttributeSet;
    private String[] disabledAttributes;
    private Set<String> disabledAttributeSet;
    
    @Override
    public void setSecretAttributes(String[] names){
        secretAttributes = names;
    }
    
    @Override
    public String[] getSecretAttributes(){
        return secretAttributes;
    }
    
    @Override
    public void setEnabledAttributes(String[] names){
        enabledAttributes = names;
    }
    
    @Override
    public String[] getEnabledAttributes(){
        return enabledAttributes;
    }
    
    @Override
    public void setDisabledAttributes(String[] names){
        disabledAttributes = names;
    }
    
    @Override
    public String[] getDisabledAttributes(){
        return disabledAttributes;
    }
    
    @Override
    public void createService(){
        secretAttributeSet = new HashSet<String>();
        enabledAttributeSet = new HashSet<String>();
        disabledAttributeSet = new HashSet<String>();
    }
    
    @Override
    public void startService(){
        if(secretAttributes != null){
            for(int i = 0; i < secretAttributes.length; i++){
                secretAttributeSet.add(secretAttributes[i]);
            }
        }
        if(enabledAttributes != null){
            for(int i = 0; i < enabledAttributes.length; i++){
                enabledAttributeSet.add(enabledAttributes[i]);
            }
        }
        if(disabledAttributes != null){
            for(int i = 0; i < disabledAttributes.length; i++){
                disabledAttributeSet.add(disabledAttributes[i]);
            }
        }
    }
    
    @Override
    public void stopService(){
        secretAttributeSet.clear();
        enabledAttributeSet.clear();
        disabledAttributeSet.clear();
    }
    
    @Override
    public void destroyService(){
        secretAttributeSet = null;
        enabledAttributeSet = null;
        disabledAttributeSet = null;
    }
    
    /**
     * W[iƂė^ꂽHttpSession^̏W[iƂďo͂MapɕϊB<br>
     * 
     * @param finder K؂JournalEditor񋟂EditorFinder
     * @param key W[ĩL[
     * @param value W[i
     * @return W[iƂďo͂Map
     */
    @Override
    protected Map<String, Object> toMap(EditorFinder finder, String key, Object value){
        final HttpSession session = (HttpSession)value;
        final Map<String, Object> result = new LinkedHashMap<String, Object>();
        
        makeIdFormat(finder, key, session, result);
        makeCreationTimeFormat(finder, key, session, result);
        makeLastAccessedTimeFormat(finder, key, session, result);
        makeMaxInactiveIntervalFormat(finder, key, session, result);
        makeIsNewFormat(finder, key, session, result);
        makeAttributesFormat(finder, key, session, result);
        return result;
    }
    
    protected Map<String, Object> makeIdFormat(
        EditorFinder finder,
        String key,
        HttpSession session,
        Map<String, Object> map
    ){
        putMap(map, ID_KEY, session.getId());
        return map;
    }
    
    protected Map<String, Object> makeCreationTimeFormat(
        EditorFinder finder,
        String key,
        HttpSession session,
        Map<String, Object> map
    ){
        putMap(map, CREATION_TIME_KEY, makeObjectFormat(finder, null, new java.util.Date(session.getCreationTime())));
        return map;
    }
    
    protected Map<String, Object> makeLastAccessedTimeFormat(
        EditorFinder finder,
        String key,
        HttpSession session,
        Map<String, Object> map
    ){
        putMap(map, LAST_ACCESSED_TIME_KEY, makeObjectFormat(finder, null, new java.util.Date(session.getLastAccessedTime())));
        return map;
    }
    
    protected Map<String, Object> makeMaxInactiveIntervalFormat(
        EditorFinder finder,
        String key,
        HttpSession session,
        Map<String, Object> map
    ){
        putMap(map, MAX_INACTIVE_INTERVAL_KEY, new Long(session.getMaxInactiveInterval()));
        return map;
    }
    
    protected Map<String, Object> makeIsNewFormat(
        EditorFinder finder,
        String key,
        HttpSession session,
        Map<String, Object> map
    ){
        putMap(map, IS_NEW_KEY, session.isNew() ? Boolean.TRUE : Boolean.FALSE);
        return map;
    }
    
    @SuppressWarnings("unchecked")
    protected Map<String, Object> makeAttributesFormat(
        EditorFinder finder,
        String key,
        HttpSession session,
        Map<String, Object> map
    ){
        if(!isOutputMapKey(ATTRIBUTES_KEY)){
            return map;
        }
        if(isSecretMapKey(ATTRIBUTES_KEY)){
            putMap(map, ATTRIBUTES_KEY, null);
            return map;
        }
        final Enumeration<String> attrNames = session.getAttributeNames();
        if(!attrNames.hasMoreElements()){
            return map;
        }
        final Map<String, Object> subMap = new LinkedHashMap<String, Object>();
        while(attrNames.hasMoreElements()){
            final String name = (String)attrNames.nextElement();
            if(!disabledAttributeSet.isEmpty()
                    && disabledAttributeSet.contains(name)){
                   continue;
               }
            if(!enabledAttributeSet.isEmpty()
                 && !enabledAttributeSet.contains(name)){
                continue;
            }
            if(secretAttributeSet.contains(name)){
                subMap.put(name, getSecretString());
            }else{
                subMap.put(
                    name,
                    makeObjectFormat(
                        finder,
                        null,
                        session.getAttribute(name)
                    )
                );
            }
        }
        putMap(map, ATTRIBUTES_KEY, subMap);
        return map;
    }
}