/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.ga;

import java.util.Random;

import jp.ossc.nimbus.service.queue.QueueHandlerContainer;

/**
 * B<p>
 *
 * @author M.Takata
 */
public interface Generation{
    
    /**
     * w肷B<p>
     *
     * @param condition 
     */
    public void setConvergenceCondition(ConvergenceCondition condition);
    
    /**
     * ㋣ɍsꍇ{@link QueueHandlerContainer}w肷B<p>
     * w肵Ȃꍇ́A{@link #compete(boolean, int, long)}̎sɓŐB<br>
     *
     * @param qhc ㋣ɍsۂɎgpQueueHandlerContainer
     */
    public void setQueueHandlerContainer(QueueHandlerContainer<?> qhc);
    
    /**
     * ㋣ɍsꍇ{@link QueueHandlerContainer}擾B<p>
     *
     * @return ㋣ɍsۂɎgpQueueHandlerContainer
     */
    public QueueHandlerContainer<?> getQueueHandlerContainer();
    
    /**
     * Kl̕яݒ肷B<p>
     *
     * @param isAsc ̏ꍇAtrue
     */
    public void setFitnessOrder(boolean isAsc);
    
    /**
     * Kl̕я擾B<p>
     *
     * @return truȅꍇA
     */
    public boolean getFitnessOrder();
    
    /**
     * ԍ擾B<p>
     *
     * @return ԍ
     */
    public int getGenerationNo();
    
    /**
     * 𐶐B<p>
     *
     * @param random V[h
     * @param seed ev[gƂȂV[h
     * @param num V[h
     */
    public void init(Random random, Seed seed, int num);
    
    /**
     * V[hւB<p>
     *
     * @param seeds V[hz
     */
    public void setSeeds(Seed[] seeds);
    
    /**
     * ̐オSẴV[h擾B<p>
     *
     * @return V[hz
     */
    public Seed[] getSeeds();
    
    /**
     * ㋣B<p>
     *
     * @exception Exception ㋣Ɏsꍇ
     */
    public void compete() throws Exception;
    
    /**
     * 񏈗Ő㋣B<p>
     *
     * @param threadNum xB{@link #setQueueHandlerContainer(QueueHandlerContainer)}QueueHandlerContainerw肳Ăꍇ́A̐ݒɏ]ߖ
     * @param timeout 񏈗ꍇɁASĂ̕񏈗Xbh̏I҂^CAEg[ms]
     * @exception Exception ㋣Ɏsꍇ
     */
    public void compete(int threadNum, long timeout) throws Exception;
    
    /**
     * 𐶐B<p>
     *
     * @param random V[h
     * @param matchMaker V[hl
     * @return BɓBꍇ́Anull
     */
    public Generation next(Random random, SeedMatchMaker matchMaker);
    
    /**
     * ҂œK҂擾B<p>
     *
     * @return V[h
     */
    public Seed getSurvivor();
}