/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.ftp.ftpclient;

import java.io.File;
import java.util.Map;

import jp.ossc.nimbus.core.*;

import org.apache.commons.net.ftp.FTPClientConfig;

/**
 * {@link FTPClientFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see FTPClientFactoryService
 */
public interface FTPClientFactoryServiceMBean extends ServiceBaseMBean{
    
    /**
     * FTPNCAg\ݒ肷B<p>
     *
     * @param config FTPNCAg\
     */
    public void setFTPClientConfig(FTPClientConfig config);
    
    /**
     * FTPNCAg\擾B<p>
     *
     * @return FTPNCAg\
     */
    public FTPClientConfig getFTPClientConfig();
    
    /**
     * pڑŎgp镶R[hݒ肷B<p>
     *
     * @param encoding R[h
     */
    public void setControlEncoding(String encoding);
    
    /**
     * pڑŎgp镶R[h擾B<p>
     *
     * @return R[h
     */
    public String getControlEncoding();
    
    public void setStrictMultilineParsing(boolean isMultiline);
    public boolean isStrictMultilineParsing();
    
    /**
     * Mobt@TCYݒ肷B<p>
     *
     * @param size Mobt@TCY[byte]
     */
    public void setSendBufferSize(int size);
    
    /**
     * Mobt@TCY擾B<p>
     *
     * @return Mobt@TCY[byte]
     */
    public int getSendBufferSize();
    
    /**
     * Mobt@TCYݒ肷B<p>
     *
     * @param size Mobt@TCY[byte]
     */
    public void setReceiveBufferSize(int size);
    
    /**
     * Mobt@TCY擾B<p>
     *
     * @return Mobt@TCY[byte]
     */
    public int getReceiveBufferSize();
    
    /**
     * pobt@TCYݒ肷B<p>
     *
     * @param size pobt@TCY[byte]
     */
    public void setBufferSize(int size);
    
    /**
     * pobt@TCY擾B<p>
     *
     * @return pobt@TCY[byte]
     */
    public int getBufferSize();
    
    /**
     * ڑ^C^Egݒ肷B<p>
     *
     * @param timeout ^C^Eg[ms]
     */
    public void setConnectTimeout(int timeout);
    
    /**
     * ڑ^C^Eg擾B<p>
     *
     * @return ^C^Eg[ms]
     */
    public int getConnectTimeout();
    
    /**
     * SO^C^Egݒ肷B<p>
     *
     * @param timeout ^C^Eg[ms]
     */
    public void setSoTimeout(int timeout);
    
    /**
     * SO^C^Eg擾B<p>
     *
     * @return ^C^Eg[ms]
     */
    public int getSoTimeout();
    
    /**
     * SOK[̒xԂݒ肷B<p>
     *
     * @param time x[ms]
     */
    public void setSoLinger(int time);
    
    /**
     * SOK[̒xԂ擾B<p>
     *
     * @return x[ms]
     */
    public int getSoLinger();
    
    /**
     * TCP_NODELAY̗L/ݒ肷B<p>
     *
     * @param noDelay Lɂꍇtrue
     */
    public void setTcpNoDelay(boolean noDelay);
    
    /**
     * TCP_NODELAY̗L/𔻒肷B<p>
     *
     * @return truȅꍇAL
     */
    public boolean isTcpNoDelay();
    
    /**
     * ڑT[õzXgݒ肷B<p>
     * ̑w肵ꍇA{@link FTPClientFactoryService#createFTPClient()}Ő{@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}́AڑςƂȂB<br>
     *
     * @param addr zXg
     */
    public void setHostName(String addr);
    
    /**
     * ڑT[õzXg擾B<p>
     *
     * @return zXg
     */
    public String getHostName();
    
    /**
     * ڑT[õ|[gԍݒ肷B<p>
     *
     * @param port |[gԍ
     */
    public void setPort(int port);
    
    /**
     * ڑT[õ|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getPort();
    
    /**
     * NCAg̃AhXݒ肷B<p>
     *
     * @param addr AhX
     */
    public void setBindAddress(String addr);
    
    /**
     * NCAg̃AhX擾B<p>
     *
     * @return AhX
     */
    public String getBindAddress();
    
    /**
     * NCAg̃|[gԍݒ肷B<p>
     *
     * @param port |[gԍ
     */
    public void setLocalPort(int port);
    
    /**
     * NCAg̃|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getLocalPort();
    
    /**
     * OC郆[Uݒ肷B<p>
     * ̑w肵ꍇA{@link FTPClientFactoryService#createFTPClient()}Ő{@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}́AOCςƂȂB<br>
     *
     * @param name [U
     */
    public void setUserName(String name);
    
    /**
     * OC郆[U擾B<p>
     *
     * @return [U
     */
    public String getUserName();
    
    /**
     * OC郆[ŨpX[hݒ肷B<p>
     *
     * @param password pX[h
     */
    public void setPassword(String password);
    
    /**
     * OC郆[ŨpX[h擾B<p>
     *
     * @return pX[h
     */
    public String getPassword();
    
    /**
     * OC̃NCAg̃z[fBNgݒ肷B<p>
     * ݒ肵Ȃꍇ́AVXevpeB"user.home"̎fBNgƂȂB<br>
     * 
     * @param dir z[fBNg
     */
    public void setHomeDirectory(File dir);
    
    /**
     * OC̃NCAg̃z[fBNg擾B<p>
     * 
     * @return z[fBNg
     */
    public File getHomeDirectory();
    
    /**
     * Java̐K\gp邩ǂݒ肷B<p>
     * trueɐݒ肵ꍇA{@link jp.ossc.nimbus.service.ftp.FTPClient#mput(String) mput(String)}A{@link jp.ossc.nimbus.service.ftp.FTPClient#mget(String) mget(String)}A{@link jp.ossc.nimbus.service.ftp.FTPClient#mdelete(String) mdelete(String)}ɂt@C̎wŁAJava̐K\gpłB<br>
     * ftHǵAfalseŁAChJ[hŵݗLB<br>
     * 
     * @param isEnabled gpꍇ́Atrue
     */
    public void setJavaRegexEnabled(boolean isEnabled);
    
    /**
     * Java̐K\gp邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAgp
     */
    public boolean isJavaRegexEnabled();
    
    /**
     * pbVuFTP邩ǂݒ肷B<p>
     *
     * @param isPassive pbVuFTPɂꍇtrue
     */
    public void setPassive(boolean isPassive);
    
    /**
     * pbVuFTP邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇApbVuFTP
     */
    public boolean isPassive();
    
    /**
     * {@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}ɐݒ肷vpeBݒ肷B<p>
     *
     * @param name vpeB
     * @param value l
     */
    public void setFTPClientProperty(String name, Object value);
    
    /**
     * {@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}̎w肳ꂽvpeB̃vpeBl擾B<p>
     *
     * @param name vpeB
     * @return l
     */
    public Object getFTPClientProperty(String name);
    
    /**
     * {@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}̎w肳ꂽvpeB̃vpeBl폜B<p>
     *
     * @param name vpeB
     */
    public void removeTPClientProperty(String name);
    
    /**
     * {@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}ɐݒ肷vpeBNAB<p>
     */
    public void clearFTPClientProperties();
    
    /**
     * {@link jp.ossc.nimbus.service.ftp.FTPClient FTPClient}ɐݒ肷vpeB擾B<p>
     *
     * @return FTPClientɐݒ肷vpeBW
     */
    public Map<String, Object> getFTPClientProperties();
}