/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.*;

import jp.ossc.nimbus.core.*;
//
/**
 * XbhReLXgT[rXB<p>
 * Xbh̃ReLXgŃL[AlǗłB<br>
 * ܂AqXbh̒l̎QƂ\łB<br>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="Context"
 *                  code="jp.ossc.nimbus.service.context.ThreadContextService"&gt;
 *             &lt;attribute name="HOME_PATH"&gt;/home&lt;/attribute&gt;
 *             &lt;attribute name="DOMAIN"&gt;nimbus2.ossc.jp&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class ThreadContextService<K, V> extends ServiceBase
 implements Context<K, V>, ThreadContextServiceMBean<K ,V>{
    
    private static final long serialVersionUID = -7304455455493489289L;
    
    /**
     * ReLXgi[pXbh[JB<p>
     */
    protected ThreadLocal<Map<K, V>> threadLocal;
    
    /**
     * ftHgli[p̃}bvB<p>
     */
    protected Map<K, V> defaultMap;
    
    /**
     * T[rX̐sB<p>
     * CX^Xϐ̏sB<br>
     * 
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        defaultMap = new HashMap<K, V>();
    }
    
    /**
     * T[rX̊JnsB<p>
     * 
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(threadLocal == null){
            clearAllThreadContext();
        }
    }
    
    /**
     * T[rX̒~sB<p>
     * 
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        clearAllThreadContext();
    }
    
    /**
     * T[rX̔jsB<p>
     * CX^Xϐ̔jsB<br>
     * 
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        defaultMap = null;
    }
    
    // ContextJavaDoc
    @Override
    public void clear(){
        Map<K, V> map = threadLocal.get();
        init(map);
    }
    
    @SuppressWarnings("unchecked")
    private void init(Map<K, V> map){
        if(map != null){
            map.clear();
            map.putAll(defaultMap);
            for(Map.Entry<K, V> entry : map.entrySet()){
                final Object val = entry.getValue();
                if(val == null){
                    continue;
                }else if(val instanceof ServiceName){
                    final ServiceName name = (ServiceName)val;
                    V service = null;
                    try{
                        service = ServiceManagerFactory.<V>getServiceObject(name);
                    }catch(ServiceNotFoundException e){
                    }
                    entry.setValue(service);
                }else if(val instanceof ServiceName[]){
                    final ServiceName[] names = (ServiceName[])val;
                    final Object[] services = new Object[names.length];
                    for(int i = 0; i < names.length; i++){
                        try{
                            services[i] = ServiceManagerFactory
                                .getServiceObject(names[i]);
                        }catch(ServiceNotFoundException e){
                        }
                    }
                    entry.setValue((V)services);
                }
            }
        }
    }
    
    // ContextJavaDoc
    @Override
    public int size(){
        Map<K, V> map = threadLocal.get();
        if(map != null){
            return map.size();
        }else{
            return 0;
        }
    }
    
    // ContextJavaDoc
    @Override
    public boolean isEmpty(){
        Map<K, V> map = threadLocal.get();
        if(map != null){
            return map.isEmpty();
        }else{
            return false;
        }
    }
    
    // ContextJavaDoc
    @Override
    public boolean containsKey(Object key){
        Map<K, V> map = threadLocal.get();
        if(map != null){
            return map.containsKey(key);
        }else{
            return false;
        }
    }
    
    // ContextJavaDoc
    @Override
    public boolean containsValue(Object value){
        Map<K, V> map = threadLocal.get();
        if(map != null){
            return map.containsValue(value);
        }else{
            return false;
        }
    }
    
    // ContextJavaDoc
    @Override
    public Set<Map.Entry<K, V>> entrySet(){
        Map<K, V> map = threadLocal.get();
        if(map != null){
            return map.entrySet();
        }else{
            return new HashSet<Map.Entry<K, V>>();
        }
    }
    
    // ContextJavaDoc
    @Override
    public V get(Object key){
        Map<K, V> map = threadLocal.get();
        return map.get(key);
    }
    
    // ContextJavaDoc
    @Override
    public V put(K key, V value){
        if(threadLocal == null){
            return defaultMap.put(key, value);
        }
        Map<K, V> map = threadLocal.get();
        return map.put(key,value);
    }
    
    // ContextJavaDoc
    @Override
    public V remove(Object key){
        Map<K, V> map = threadLocal.get();
        if(map != null){
            return map.remove(key);
        }else{
            return null;
        }
    }
    
    // ContextJavaDoc
    @Override
    public void putAll(Map<? extends K, ? extends V> t){
        Map<K, V> map = threadLocal.get();
        map.putAll(t);
    }
    
    // ContextJavaDoc
    @Override
    public Set<K> keySet(){
        Map<K, V> map = threadLocal.get();
        return map.keySet();
    }
    
    // ContextJavaDoc
    @Override
    public Collection<V> values(){
        Map<K, V> map = threadLocal.get();
        return map.values();
    }
    
    // ContextJavaDoc
    public Map<K, V> all(){
        Map<K, V> map = threadLocal.get();
        return new HashMap<K, V>(map);
    }
    
    public Map<K, V> getDefaultMap(){
        return defaultMap;
    }
    
    // ThreadContextServiceMBeanJavaDoc
    @Override
    public void clearAllThreadContext(){
        threadLocal = new ThreadLocal<Map<K, V>>(){
            @Override
            protected synchronized Map<K, V> initialValue(){
                final Map<K, V> map = Collections.synchronizedMap(new HashMap<K, V>());
                init(map);
                return map;
            }
        };
    }
    
    @Override
    public void load() throws Exception{
        throw new UnsupportedOperationException();
    }
    
    @Override
    public void loadKey() throws Exception{
        throw new UnsupportedOperationException();
    }
    
    @Override
    public void load(Object key) throws Exception{
        throw new UnsupportedOperationException();
    }
    
    @Override
    public void save() throws Exception{
        throw new UnsupportedOperationException();
    }
}
