/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DatabaseSharedContextKeyDistributorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DatabaseSharedContextKeyDistributorService
 */
public interface DatabaseSharedContextKeyDistributorServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rX擾B<p>
     * 
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.sql.PersistentManager PersistentManager}T[rX̃T[rXݒ肷B<p>
     * 
     * @param name PersistentManagerT[rX̃T[rX
     */
    public void setPersistentManagerServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sql.PersistentManager PersistentManager}T[rX̃T[rX擾B<p>
     * 
     * @return PersistentManagerT[rX̃T[rX
     */
    public ServiceName getPersistentManagerServiceName();
    
    /**
     * L[錟NGݒ肷B<p>
     *
     * @param query NG
     */
    public void setKeySelectQuery(String query);
    
    /**
     * L[錟NG擾B<p>
     *
     * @return NG
     */
    public String getKeySelectQuery();
    
    /**
     * f[^x[X猟L[ǂݍރR[hݒ肷B<p>
     * PersistentManagerɃR[hɃ[hÃvpeB肾ăL[Ƃꍇ́A{@link #setKeyPropertyName(String)}Ƒgݍ킹Đݒ肷B<br>
     *
     * @param record ǂݍ݃R[h
     */
    public void setDatabaseRecord(Record record);
    
    /**
     * f[^x[X猟L[ǂݍރR[h擾B<p>
     *
     * @return ǂݍ݃R[h
     */
    public Record getDatabaseRecord();
    
    /**
     * f[^x[X猟L[ǂݍBeañNXݒ肷B<p>
     * PersistentManagerɂBean𒼐ڃ[hꍇ́Ȃ̂ݐݒ肷B<br>
     * PersistentManagerɃR[hɃ[hÃvpeBR[h擾āABeanɐݒ肵ꍇ́A{@link #setKeyPropertyMapping(String, String)}Ƒgݍ킹Đݒ肷B<br>
     * 
     * @param clazz ǂݍBeañNX
     */
    public void setKeyClass(Class<?> clazz);
    
    /**
     * f[^x[X猟L[ǂݍBeañNX擾B<p>
     *
     * @return ǂݍBeañNX
     */
    public Class<?> getKeyClass();
    
    /**
     * R[h擾L[̃vpeBݒ肷B<p>
     *
     * @param name vpeB
     * @see #setDatabaseRecord(Record)
     */
    public void setKeyPropertyName(String name);
    
    /**
     * R[h擾L[̃vpeB擾B<p>
     *
     * @return vpeB
     */
    public String getKeyPropertyName();
    
    
    /**
     * R[h擾Beanɐݒ肷vpeB̃}bsOݒ肷B<p>
     *
     * @param getProperty R[h擾vpeB
     * @param setProperty Beanɐݒ肷vpeB
     * @see #setKeyClass(Class)
     */
    public void setKeyPropertyMapping(String getProperty, String setProperty);
}