/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.util.*;

/**
 * LbVB<p>
 *
 * @author M.Takata
 */
public interface Cache<E>{
    
    /**
     * w肳ꂽIuWFNgLbVB<p>
     *
     * @param obj LbVIuWFNg
     * @return LbVQ
     */
    public CachedReference<E> add(E obj);
    
    /**
     * LbVĂIuWFNg̃LbVQƂ̔q擾B<p>
     *
     * @return LbVQƂ̔q
     */
    public Iterator<CachedReference<E>> iterator();
    
    /**
     * w肳ꂽLbVQƂ܂ނǂ𒲂ׂB<p>
     * 
     * @param ref LbVQ
     * @return w肳ꂽLbVQƂ܂ޏꍇtrue
     */
    public boolean contains(Object ref);
    
    /**
     * w肳ꂽLbVQƂ̏WSĊ܂ނǂ𒲂ׂB<p>
     * 
     * @param c LbVQƂ̏W
     * @return w肳ꂽLbVQƂ̏WSĊ܂ޏꍇtrue
     */
    public boolean containsAll(Collection<?> c);
    
    /**
     * LbV󂩂ǂׂB<p>
     *
     * @return LbV̏ꍇtrue
     */
    public boolean isEmpty();
    
    /**
     * w肳ꂽLbVQƂLbVIuWFNg폜B<p>
     *
     * @param ref LbVQ
     * @return w肳ꂽLbVQƂLbVIuWFNg폜鎖ŁÃLbV̓eύXꂽꍇtrue
     */
    public boolean remove(Object ref);
    
    /**
     * w肳ꂽLbVQƂ̏WLbVIuWFNg폜B<p>
     *
     * @param c LbVQƂ̏W
     * @return w肳ꂽLbVQƂ̏WLbVIuWFNg폜鎖ŁÃLbV̓eύXꂽꍇtrue
     */
    public boolean removeAll(Collection<?> c);
    
    /**
     * w肳ꂽLbVQƂ̏WLbVIuWFNgȊO폜B<p>
     *
     * @param c LbVQƂ̏W
     * @return w肳ꂽLbVQƂ̏WLbVIuWFNgȊO폜鎖ŁÃLbV̓eύXꂽꍇtrue
     */
    public boolean retainAll(Collection<?> c);
    
    /**
     * LbVĂIuWFNg̐擾B<p>
     *
     * @return LbVĂIuWFNg̐
     */
    public int size();
    
    /**
     * LbVĂIuWFNgSăLbV폜B<p>
     */
    public void clear();
    
    /**
     * LbVĂLbVQƂ̔z擾B<p>
     *
     * @return LbVQƂ̔z
     */
    public Object[] toArray();
    
    /**
     * LbVĂLbVQƂ̔z擾B<p>
     * Ŏw肳ꂽLbVQƔz̒Ã\bȟĂяǒʕԂLbVQƔz̒ȉ̏ꍇ́AŎw肳ꂽLbVQƔzɌʂi[ĕԂBłȂꍇ́AVLbVQƔz𐶐āAʂi[ĕԂB<br>
     *
     * @param refs LbVQƂ̔z
     * @return LbVQƂ̔z
     */
    public <T> CachedReference<T>[] toArray(CachedReference<T>[] refs);
}
