/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;

import java.util.*;

/**
 * `FbN|CgC^[Zv^B<p>
 * \bȟĂяoɑ΂āAʉ߂XbhL^C^[Zv^łB<br>
 * ȉɁA`FbN|CgC^[Zv^̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="CheckPointInterceptor"
 *                  code="jp.ossc.nimbus.service.aop.interceptor.CheckPointInterceptorService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class CheckPointInterceptorService extends ServiceBase
 implements Interceptor, CheckPointInterceptorServiceMBean{
    
    private static final long serialVersionUID = -7319984801053501636L;
    
    private String checkPointName;
    private boolean enabled = true;
    private List<String> passOverThreads = new ArrayList<String>();
    private ServiceName checkPointTracerServiceName;
    private CheckPointTracer checkPointTracer;
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public void setEnabled(boolean enabled){
        this.enabled = enabled;
    }
    // CheckPointInterceptorServiceMBeanJavaDoc
    public boolean isEnabled(){
        return enabled;
    }
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public List<String> passOverThreads(){
        synchronized(passOverThreads){
            return new ArrayList<String>(passOverThreads);
        }
    }
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public void clear(){
        if(passOverThreads != null){
            passOverThreads.clear();
        }
    }
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public void setCheckPointName(String name){
        checkPointName = name;
    }
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public String getCheckPointName(){
        if(checkPointName == null && getServiceNameObject() != null){
            return getServiceNameObject().toString();
        }
        return checkPointName;
    }
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public void setCheckPointTracerServiceName(ServiceName name){
        checkPointTracerServiceName = name;
    }
    
    // CheckPointInterceptorServiceMBeanJavaDoc
    public ServiceName getCheckPointTracerServiceName(){
        return checkPointTracerServiceName;
    }
    
    /**
     * {@link CheckPointTracer}ݒ肷B<p>
     *
     * @param tracer CheckPointTracer
     */
    public void setCheckPointTracer(CheckPointTracer tracer){
        checkPointTracer = tracer;
    }
    
    public void startService() throws Exception{
        if(checkPointTracerServiceName != null){
            checkPointTracer = ServiceManagerFactory.getServiceObject(checkPointTracerServiceName);
        }
    }
    
    public void stopService() throws Exception{
        clear();
    }
    
    /**
     * ʉ߂XbhL^āÃC^[Zv^ĂяoB<p>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invoke(
        InvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() == State.STARTED && enabled){
            final String threadName = Thread.currentThread().getName();
            synchronized(passOverThreads){
                passOverThreads.add(threadName);
            }
            if(checkPointTracer != null){
                checkPointTracer.passedCheckPoint(threadName, this);
            }
        }
        return chain.invokeNext(context);
    }
}
